"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCategorizeRequest = useCategorizeRequest;
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _create_category_request = require("@kbn/aiops-log-pattern-analysis/create_category_request");
var _process_category_results = require("@kbn/aiops-log-pattern-analysis/process_category_results");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _sampling_menu = require("./sampling_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCategorizeRequest(randomSamplerStorage) {
  const {
    data
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const abortController = (0, _react.useRef)(new AbortController());
  const randomSampler = (0, _react.useMemo)(() => new _sampling_menu.RandomSampler(randomSamplerStorage),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const runCategorizeRequest = (0, _react.useCallback)((index, field, timeField, timeRange, query, runtimeMappings, intervalMs, additionalFilter) => {
    const {
      wrap,
      unwrap
    } = randomSampler.createRandomSamplerWrapper();
    return new Promise((resolve, reject) => {
      data.search.search((0, _create_category_request.createCategoryRequest)(index, field, timeField, timeRange, query, runtimeMappings, wrap, intervalMs, additionalFilter, true, additionalFilter === undefined // don't include the outer sparkline if there is an additional filter
      ), {
        abortSignal: abortController.current.signal
      }).subscribe({
        next: result => {
          if (!(0, _public.isRunningResponse)(result)) {
            resolve((0, _process_category_results.processCategoryResults)(result, field, unwrap));
          } else {
            // partial results
            // Ignore partial results for now.
            // An issue with the search function means partial results are not being returned correctly.
          }
        },
        error: error => {
          if (error.name === 'AbortError') {
            return resolve({
              categories: [],
              hasExamples: false
            });
          }
          reject(error);
        }
      });
    });
  }, [data.search, randomSampler]);
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController();
  }, []);
  return {
    runCategorizeRequest,
    cancelRequest,
    randomSampler
  };
}