"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = exports.LOG_RATE_ANALYSIS_RESULTS_TABLE_TYPE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _get_category_query = require("@kbn/aiops-log-pattern-analysis/get_category_query");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _log_rate_analysis_table_slice = require("@kbn/aiops-log-rate-analysis/state/log_rate_analysis_table_slice");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _get_failed_transactions_correlation_impact_label = require("./get_failed_transactions_correlation_impact_label");
var _field_stats_popover = require("../field_stats_popover");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _use_view_in_discover_action = require("./use_view_in_discover_action");
var _use_view_in_log_pattern_analysis_action = require("./use_view_in_log_pattern_analysis_action");
var _use_copy_to_clipboard_action = require("./use_copy_to_clipboard_action");
var _mini_histogram = require("../mini_histogram");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis_results_table/use_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TRUNCATE_TEXT_LINES = 3;
const UNIQUE_COLUMN_WIDTH = '40px';
const NOT_AVAILABLE = '--';
const LOG_RATE_ANALYSIS_RESULTS_TABLE_TYPE = exports.LOG_RATE_ANALYSIS_RESULTS_TABLE_TYPE = {
  GROUPS: 'groups',
  SIGNIFICANT_ITEMS: 'significantItems'
};
const logRateHelpMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.logRateColumnTooltip', {
  defaultMessage: 'A visual representation of the impact of the field on the message rate difference'
});
const groupLogRateHelpMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.logRateColumnTooltip', {
  defaultMessage: 'A visual representation of the impact of the group on the message rate difference.'
});
const logRateChangeMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.logRateChangeLabelColumnTooltip', {
  defaultMessage: 'The factor by which the log rate changed. This value is normalized to account for differing lengths in baseline and deviation time ranges.'
});
const baselineRateMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.baselineRateLabelColumnTooltip', {
  defaultMessage: 'The average number of documents per baseline bucket.'
});
const deviationRateMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.deviationRateLabelColumnTooltip', {
  defaultMessage: 'The average number of documents per deviation bucket.'
});

// EuiInMemoryTable stores column `name` in its own memory as an object and computed columns may be updating dynamically which means the reference is no longer ===.
// Need to declare name react node outside to keep it static and maintain reference equality.
const LogRateColumnName = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.aiops.logRateAnalysis.resultsTable.logRateChangeLabel",
  defaultMessage: "Log rate change",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 5
  }
}), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  size: "s",
  position: "top",
  color: "subdued",
  type: "question",
  className: "eui-alignTop",
  content: logRateChangeMessage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 5
  }
}));
const ImpactColumnName = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.aiops.logRateAnalysis.resultsTable.impactLabel",
  defaultMessage: "Impact",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 111,
    columnNumber: 5
  }
}), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  size: "s",
  position: "top",
  color: "subdued",
  type: "question",
  className: "eui-alignTop",
  content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.impactLabelColumnTooltip', {
    defaultMessage: 'The level of impact of the field on the message rate difference.'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 116,
    columnNumber: 5
  }
}));
const GroupImpactColumnName = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.aiops.logRateAnalysis.resultsTable.impactLabel",
  defaultMessage: "Impact",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 131,
    columnNumber: 5
  }
}), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  size: "s",
  position: "top",
  color: "subdued",
  type: "question",
  className: "eui-alignTop",
  content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.impactLabelColumnTooltip', {
    defaultMessage: 'The level of impact of the group on the message rate difference'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 136,
    columnNumber: 5
  }
}));
const useColumns = (tableType, skippedColumns, searchQuery, barColorOverride, barHighlightColorOverride, isExpandedRow = false) => {
  var _documentCountStats$i;
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const viewInDiscoverAction = (0, _use_view_in_discover_action.useViewInDiscoverAction)(dataView.id);
  const viewInLogPatternAnalysisAction = (0, _use_view_in_log_pattern_analysis_action.useViewInLogPatternAnalysisAction)(dataView.id);
  const copyToClipBoardAction = (0, _use_copy_to_clipboard_action.useCopyToClipboardAction)();
  const {
    earliest,
    latest
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const timeRangeMs = {
    from: earliest !== null && earliest !== void 0 ? earliest : 0,
    to: latest !== null && latest !== void 0 ? latest : 0
  };
  const loading = (0, _state.useAppSelector)(s => s.stream.isRunning);
  const zeroDocsFallback = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.zeroDocsFallback);
  const {
    documentStats: {
      documentCountStats
    }
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const {
    currentAnalysisType,
    currentAnalysisWindowParameters
  } = (0, _state.useAppSelector)(s => s.logRateAnalysisResults);
  const isGroupsTable = tableType === LOG_RATE_ANALYSIS_RESULTS_TABLE_TYPE.GROUPS;
  const interval = (_documentCountStats$i = documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.interval) !== null && _documentCountStats$i !== void 0 ? _documentCountStats$i : 0;
  const fieldStatsServices = (0, _react.useMemo)(() => {
    return {
      uiSettings,
      dataViews: data.dataViews,
      data,
      fieldFormats,
      charts
    };
  }, [uiSettings, data, fieldFormats, charts]);
  const buckets = (0, _react.useMemo)(() => {
    if (currentAnalysisWindowParameters === undefined) return;
    const {
      baselineMin,
      baselineMax,
      deviationMin,
      deviationMax
    } = currentAnalysisWindowParameters;
    const baselineBuckets = (baselineMax - baselineMin) / interval;
    const deviationBuckets = (deviationMax - deviationMin) / interval;
    return {
      baselineBuckets,
      deviationBuckets
    };
  }, [currentAnalysisWindowParameters, interval]);
  const logRateChangeNotAvailable = (0, _react.useMemo)(() => interval === 0 || currentAnalysisType === undefined || currentAnalysisWindowParameters === undefined || buckets === undefined || isGroupsTable, [interval, currentAnalysisType, currentAnalysisWindowParameters, buckets, isGroupsTable]);
  const getLogRateChangeValues = (0, _react.useCallback)((docCount, bgCount) => {
    const {
      baselineBucketRate,
      deviationBucketRate
    } = (0, _aiopsLogRateAnalysis.getBaselineAndDeviationRates)(currentAnalysisType, buckets.baselineBuckets, buckets.deviationBuckets, docCount, bgCount);
    return (0, _aiopsLogRateAnalysis.getLogRateChange)(currentAnalysisType, baselineBucketRate, deviationBucketRate);
  }, [currentAnalysisType, buckets]);
  const columnsMap = (0, _react.useMemo)(() => ({
    ['Field name']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnFieldName',
      field: 'fieldName',
      width: skippedColumns.length < 3 ? '17%' : '25%',
      name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.fieldNameLabel', {
        defaultMessage: 'Field name'
      }),
      render: (_, {
        fieldName,
        fieldValue,
        key,
        type,
        doc_count: count
      }) => {
        const dslQuery = type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD ? searchQuery : (0, _get_category_query.getCategoryQuery)(fieldName, [{
          key,
          count,
          examples: [],
          regex: ''
        }]);
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD && /*#__PURE__*/_react.default.createElement(_field_stats_popover.FieldStatsPopover, {
          dataView: dataView,
          fieldName: fieldName,
          fieldValue: type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD ? fieldValue : key,
          fieldStatsServices: fieldStatsServices,
          dslQuery: dslQuery,
          timeRangeMs: timeRangeMs,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 255,
            columnNumber: 17
          }
        }), type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.LOG_PATTERN && /*#__PURE__*/_react.default.createElement("span", {
          // match the margins of the FieldStatsPopover button
          css: {
            marginLeft: euiTheme.size.s,
            marginRight: euiTheme.size.xs
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 265,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "aggregate",
          "data-test-subj": 'aiopsLogPatternIcon',
          size: "m",
          content: _i18n.i18n.translate('xpack.aiops.fieldContextPopover.descriptionTooltipLogPattern', {
            defaultMessage: 'The field value for this field shows an example of the identified significant text field pattern.'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 272,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement("span", {
          title: fieldName,
          className: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 287,
            columnNumber: 15
          }
        }, fieldName));
      },
      sortable: true,
      valign: 'middle'
    },
    ['Field value']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnFieldValue',
      field: 'fieldValue',
      width: skippedColumns.length < 3 ? '17%' : '25%',
      name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.fieldValueLabel', {
        defaultMessage: 'Field value'
      }),
      render: (_, {
        fieldValue,
        type
      }) => /*#__PURE__*/_react.default.createElement("span", {
        title: String(fieldValue),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 11
        }
      }, type === 'keyword' ? String(fieldValue) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        language: "log",
        transparentBackground: true,
        css: {
          paddingInline: '0px'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 309,
          columnNumber: 17
        }
      }, String(fieldValue)))),
      sortable: true,
      textOnly: true,
      truncateText: {
        lines: TRUNCATE_TEXT_LINES
      },
      valign: 'middle'
    },
    ['Log rate']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnLogRate',
      width: '8%',
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTable.logRateLabel",
        defaultMessage: "Log rate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 327,
          columnNumber: 13
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        position: "top",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        content: isGroupsTable ? groupLogRateHelpMessage : logRateHelpMessage,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 332,
          columnNumber: 13
        }
      })),
      render: (_, {
        histogram,
        fieldName,
        fieldValue
      }) => /*#__PURE__*/_react.default.createElement(_mini_histogram.MiniHistogram, {
        chartData: histogram,
        isLoading: loading && histogram === undefined,
        label: `${fieldName}:${fieldValue}`,
        barColorOverride: barColorOverride,
        barHighlightColorOverride: barHighlightColorOverride,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 11
        }
      }),
      sortable: false,
      valign: 'middle'
    },
    ['Impact']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnImpact',
      width: '8%',
      field: 'pValue',
      name: isGroupsTable ? GroupImpactColumnName : ImpactColumnName,
      // content={isGroupsTable ? groupImpactMessage : impactMessage}
      render: (_, {
        pValue
      }) => {
        if (typeof pValue !== 'number') return NOT_AVAILABLE;
        const label = (0, _get_failed_transactions_correlation_impact_label.getFailedTransactionsCorrelationImpactLabel)(pValue);
        return label ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: label.color,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 362,
            columnNumber: 26
          }
        }, label.impact) : null;
      },
      sortable: true,
      valign: 'middle'
    },
    ['Baseline rate']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnBaselineRateChange',
      field: 'bg_count',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTable.baselineRateLabel",
        defaultMessage: "Baseline rate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 372,
          columnNumber: 13
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        position: "top",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        content: baselineRateMessage,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 377,
          columnNumber: 13
        }
      })),
      render: (_, {
        bg_count: bgCount,
        doc_count: docCount
      }) => {
        if (interval === 0 || currentAnalysisType === undefined || currentAnalysisWindowParameters === undefined || buckets === undefined || isGroupsTable) return NOT_AVAILABLE;
        const {
          baselineBucketRate
        } = (0, _aiopsLogRateAnalysis.getBaselineAndDeviationRates)(currentAnalysisType, buckets.baselineBuckets, buckets.deviationBuckets, docCount, bgCount);
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, baselineBucketRate);
      },
      sortable: true,
      valign: 'middle'
    },
    ['Deviation rate']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnDeviationRateChange',
      field: 'doc_count',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTable.deviationRateLabel",
        defaultMessage: "Deviation rate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 415,
          columnNumber: 13
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        position: "top",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        content: deviationRateMessage,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 420,
          columnNumber: 13
        }
      })),
      render: (_, {
        doc_count: docCount,
        bg_count: bgCount
      }) => {
        if (interval === 0 || currentAnalysisType === undefined || currentAnalysisWindowParameters === undefined || buckets === undefined || isGroupsTable) return NOT_AVAILABLE;
        const {
          deviationBucketRate
        } = (0, _aiopsLogRateAnalysis.getBaselineAndDeviationRates)(currentAnalysisType, buckets.baselineBuckets, buckets.deviationBuckets, docCount, bgCount);
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deviationBucketRate);
      },
      sortable: true,
      valign: 'middle'
    },
    ['Log rate change']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnLogRateChange',
      field: 'logRateChangeSort',
      name: LogRateColumnName,
      sortable: isGroupsTable ? false : true,
      render: (_, {
        doc_count: docCount,
        bg_count: bgCount
      }) => {
        if (logRateChangeNotAvailable) return NOT_AVAILABLE;
        const logRateChange = getLogRateChangeValues(docCount, bgCount);
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          color: "subdued",
          type: currentAnalysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'sortUp' : 'sortDown',
          className: "eui-alignTop",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 464,
            columnNumber: 15
          }
        }), "\xA0", logRateChange.message);
      },
      valign: 'middle'
    },
    ['p-value']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnPValue',
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTable.pValueLabel",
        defaultMessage: "p-value",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 482,
          columnNumber: 13
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        position: "top",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.pValueColumnTooltip', {
          defaultMessage: 'The significance of changes in the frequency of values; lower values indicate greater change; sorting this column will automatically do a secondary sort on the doc count column.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 487,
          columnNumber: 13
        }
      })),
      render: pValue => {
        var _pValue$toPrecision;
        return (_pValue$toPrecision = pValue === null || pValue === void 0 ? void 0 : pValue.toPrecision(3)) !== null && _pValue$toPrecision !== void 0 ? _pValue$toPrecision : NOT_AVAILABLE;
      },
      sortable: true,
      valign: 'middle'
    },
    ['Doc count']: {
      'data-test-subj': isGroupsTable ? 'aiopsLogRateAnalysisResultsGroupsTableColumnDocCount' : 'aiopsLogRateAnalysisResultsTableColumnDocCount',
      width: '8%',
      field: isGroupsTable ? 'docCount' : 'doc_count',
      name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.docCountLabel', {
        defaultMessage: 'Doc count'
      }),
      sortable: true,
      valign: 'middle'
    },
    ['Actions']: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnAction',
      name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.actionsColumnName', {
        defaultMessage: 'Actions'
      }),
      actions: [...(viewInDiscoverAction ? [viewInDiscoverAction] : []), ...(viewInLogPatternAnalysisAction ? [viewInLogPatternAnalysisAction] : []), copyToClipBoardAction],
      width: '4%',
      valign: 'middle'
    },
    unique: {
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnUnique',
      width: UNIQUE_COLUMN_WIDTH,
      field: 'unique',
      name: '',
      render: (_, {
        unique
      }) => {
        if (unique) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.uniqueColumnTooltip', {
              defaultMessage: 'This field/value pair only appears in this group'
            }),
            position: "top",
            type: "asterisk",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 540,
              columnNumber: 15
            }
          });
        }
        return '';
      },
      sortable: false,
      valign: 'middle'
    }
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [barColorOverride, barHighlightColorOverride, copyToClipBoardAction, dataView === null || dataView === void 0 ? void 0 : dataView.id, euiTheme, fieldStatsServices, loading, searchQuery, timeRangeMs, viewInDiscoverAction, viewInLogPatternAnalysisAction]);
  const columns = (0, _react.useMemo)(() => {
    const columnNamesToReturn = isGroupsTable ? _log_rate_analysis_table_slice.commonColumns : _log_rate_analysis_table_slice.significantItemColumns;
    const columnsToReturn = [];
    for (const columnName in columnNamesToReturn) {
      if (Object.hasOwn(columnNamesToReturn, columnName) === false || skippedColumns.includes(columnNamesToReturn[columnName]) || (columnName === 'p-value' || columnName === 'Impact') && zeroDocsFallback) continue;
      columnsToReturn.push(columnsMap[columnName]);
    }
    if (isExpandedRow === true) {
      columnsToReturn.unshift(columnsMap.unique);
    }
    return columnsToReturn;
  }, [isGroupsTable, skippedColumns, zeroDocsFallback, isExpandedRow, columnsMap]);
  return columns;
};
exports.useColumns = useColumns;