"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddablePatternAnalysisUserInput = resolveEmbeddablePatternAnalysisUserInput;
var _presentationUtil = require("@kbn/presentation-util");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _pattern_analysis_initializer = require("./pattern_analysis_initializer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/pattern_analysis/resolve_pattern_analysis_config_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function resolveEmbeddablePatternAnalysisUserInput(coreStart, pluginStart, parentApi, focusedPanelId, isNewPanel, patternAnalysisControlsApi, deletePanel, initialState) {
  const {
    overlays
  } = coreStart;
  const overlayTracker = (0, _presentationUtil.tracksOverlays)(parentApi) ? parentApi : undefined;
  let hasChanged = false;
  return new Promise(async (resolve, reject) => {
    try {
      const cancelChanges = () => {
        if (isNewPanel && deletePanel) {
          deletePanel();
        } else if (hasChanged && patternAnalysisControlsApi && initialState) {
          // Reset to initialState in case user has changed the preview state
          patternAnalysisControlsApi.updateUserInput(initialState);
        }
        flyoutSession.close();
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
      };
      const update = async nextUpdate => {
        resolve(nextUpdate);
        flyoutSession.close();
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
      };
      const preview = async nextUpdate => {
        if (patternAnalysisControlsApi) {
          patternAnalysisControlsApi.updateUserInput(nextUpdate);
          hasChanged = true;
        }
      };
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
        value: {
          embeddingOrigin: 'flyout',
          ...coreStart,
          ...pluginStart
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_pattern_analysis_initializer.PatternAnalysisEmbeddableInitializer, {
        initialInput: initialState,
        onCreate: update,
        onCancel: cancelChanges,
        onPreview: preview,
        isNewPanel: isNewPanel,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      })), coreStart), {
        ownFocus: true,
        size: 's',
        type: 'push',
        paddingSize: 'm',
        hideCloseButton: true,
        'data-test-subj': 'aiopsPatternAnalysisEmbeddableInitializer',
        'aria-labelledby': 'patternAnalysisConfig',
        onClose: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      });
      if ((0, _presentationUtil.tracksOverlays)(parentApi)) {
        parentApi.openOverlay(flyoutSession, {
          focusedPanelId
        });
      }
    } catch (error) {
      reject(error);
    }
  });
}