"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalExecutionSummarySchema = exports.getGlobalExecutionSummaryResponseBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGlobalExecutionSummarySchema = exports.getGlobalExecutionSummarySchema = _configSchema.schema.object({
  date_start: _configSchema.schema.string(),
  date_end: _configSchema.schema.string()
}, {
  validate({
    date_start: start,
    date_end: end
  }) {
    const parsedStart = Date.parse(start);
    if (isNaN(parsedStart)) {
      return `[start]: query start must be valid date`;
    }
    const parsedEnd = Date.parse(end);
    if (isNaN(parsedEnd)) {
      return `[end]: query end must be valid date`;
    }
    if (parsedStart >= parsedEnd) {
      return `[start]: query start must be before end`;
    }
  }
});
const positiveNumber = _configSchema.schema.number({
  min: 0
});
const getGlobalExecutionSummaryResponseBodySchema = exports.getGlobalExecutionSummaryResponseBodySchema = _configSchema.schema.object({
  executions: _configSchema.schema.object({
    total: positiveNumber,
    success: positiveNumber
  }),
  latestExecutionSummary: _configSchema.schema.object({
    success: positiveNumber,
    failure: positiveNumber,
    warning: positiveNumber
  })
});