"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findRuleTemplatesRequestQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schemas = require("../../../../../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findRuleTemplatesRequestQuerySchema = exports.findRuleTemplatesRequestQuerySchema = _configSchema.schema.object({
  per_page: _configSchema.schema.number({
    defaultValue: 10,
    min: 0,
    max: 100,
    meta: {
      description: 'The number of rule templates to return per page.'
    }
  }),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1,
    meta: {
      description: 'The page number to return.'
    }
  }),
  search: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An Elasticsearch simple_query_string query that filters the objects in the response.'
    }
  })),
  default_search_operator: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('OR'), _configSchema.schema.literal('AND')], {
    defaultValue: 'OR',
    meta: {
      description: 'The default operator to use for the simple_query_string.'
    }
  })),
  sort_field: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('name'), _configSchema.schema.literal('tags')], {
    defaultValue: 'name',
    meta: {
      description: 'Determines which field is used to sort the results.'
    }
  })),
  sort_order: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
    defaultValue: 'asc',
    meta: {
      description: 'Determines the sort order.'
    }
  })),
  rule_type_id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Filters the rule templates by rule type identifier.'
    }
  })),
  tags: _configSchema.schema.maybe((0, _schemas.stringOrStringArraySchema)({
    meta: {
      description: 'Filters the rule templates by tags.'
    }
  }))
});