"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateTimezone = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateTimezone = timezone => {
  if (timezone && _momentTimezone.default.tz.zone(timezone) == null) {
    return `Invalid schedule timezone: ${timezone}`;
  }
  return;
};
exports.validateTimezone = validateTimezone;