"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertNavigationRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_HANDLER = Symbol('*');
class AlertNavigationRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "alertNavigations", new Map());
  }
  has(consumer, alertType) {
    return this.hasTypedHandler(consumer, alertType.id) || this.hasDefaultHandler(consumer);
  }
  hasTypedHandler(consumer, ruleTypeId) {
    var _this$alertNavigation, _this$alertNavigation2;
    return (_this$alertNavigation = (_this$alertNavigation2 = this.alertNavigations.get(consumer)) === null || _this$alertNavigation2 === void 0 ? void 0 : _this$alertNavigation2.has(ruleTypeId)) !== null && _this$alertNavigation !== void 0 ? _this$alertNavigation : false;
  }
  hasDefaultHandler(consumer) {
    var _this$alertNavigation3, _this$alertNavigation4;
    return (_this$alertNavigation3 = (_this$alertNavigation4 = this.alertNavigations.get(consumer)) === null || _this$alertNavigation4 === void 0 ? void 0 : _this$alertNavigation4.has(DEFAULT_HANDLER)) !== null && _this$alertNavigation3 !== void 0 ? _this$alertNavigation3 : false;
  }
  createConsumerNavigation(consumer) {
    const consumerNavigations = new Map();
    this.alertNavigations.set(consumer, consumerNavigations);
    return consumerNavigations;
  }
  registerDefault(consumer, handler) {
    var _this$alertNavigation5;
    if (this.hasDefaultHandler(consumer)) {
      throw new Error(_i18n.i18n.translate('xpack.alerting.alertNavigationRegistry.register.duplicateDefaultError', {
        defaultMessage: 'Default Navigation within "{consumer}" is already registered.',
        values: {
          consumer
        }
      }));
    }
    const consumerNavigations = (_this$alertNavigation5 = this.alertNavigations.get(consumer)) !== null && _this$alertNavigation5 !== void 0 ? _this$alertNavigation5 : this.createConsumerNavigation(consumer);
    consumerNavigations.set(DEFAULT_HANDLER, handler);
  }
  register(consumer, ruleTypeId, handler) {
    var _this$alertNavigation6;
    if (this.hasTypedHandler(consumer, ruleTypeId)) {
      throw new Error(_i18n.i18n.translate('xpack.alerting.alertNavigationRegistry.register.duplicateNavigationError', {
        defaultMessage: 'Navigation for Alert type "{alertType}" within "{consumer}" is already registered.',
        values: {
          alertType: ruleTypeId,
          consumer
        }
      }));
    }
    const consumerNavigations = (_this$alertNavigation6 = this.alertNavigations.get(consumer)) !== null && _this$alertNavigation6 !== void 0 ? _this$alertNavigation6 : this.createConsumerNavigation(consumer);
    consumerNavigations.set(ruleTypeId, handler);
  }
  get(consumer, alertType) {
    if (this.has(consumer, alertType)) {
      var _consumerHandlers$get;
      const consumerHandlers = this.alertNavigations.get(consumer);
      return (_consumerHandlers$get = consumerHandlers.get(alertType.id)) !== null && _consumerHandlers$get !== void 0 ? _consumerHandlers$get : consumerHandlers.get(DEFAULT_HANDLER);
    }
    throw new Error(_i18n.i18n.translate('xpack.alerting.alertNavigationRegistry.get.missingNavigationError', {
      defaultMessage: 'Navigation for Alert type "{alertType}" within "{consumer}" is not registered.',
      values: {
        alertType: alertType.id,
        consumer
      }
    }));
  }
}
exports.AlertNavigationRegistry = AlertNavigationRegistry;