"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MaintenanceWindowsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/maintenance-windows-plugin/common");
var _kibana_react = require("../../utils/kibana_react");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _empty_prompt = require("./components/empty_prompt");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_navigation = require("../../hooks/use_navigation");
var _maintenance_windows_list = require("./components/maintenance_windows_list");
var _use_find_maintenance_windows = require("../../hooks/use_find_maintenance_windows");
var _use_license = require("../../hooks/use_license");
var _license_prompt = require("./components/license_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MaintenanceWindowsPage = exports.default = exports.MaintenanceWindowsPage = /*#__PURE__*/_react.default.memo(() => {
  var _capabilities$MAINTEN, _capabilities$MAINTEN2;
  const {
    application: {
      capabilities
    },
    chrome,
    docLinks
  } = (0, _kibana_react.useKibana)().services;
  const {
    isAtLeastPlatinum
  } = (0, _use_license.useLicense)();
  const hasLicense = isAtLeastPlatinum();
  const [page, setPage] = (0, _react.useState)(_common.MAINTENANCE_WINDOW_DEFAULT_TABLE_ACTIVE_PAGE);
  const [perPage, setPerPage] = (0, _react.useState)(_common.MAINTENANCE_WINDOW_DEFAULT_PER_PAGE);
  const [selectedStatus, setSelectedStatus] = (0, _react.useState)([]);
  const [search, setSearch] = (0, _react.useState)('');
  const {
    navigateToCreateMaintenanceWindow
  } = (0, _use_navigation.useCreateMaintenanceWindowNavigation)();
  const {
    isLoading,
    isInitialLoading,
    data,
    refetch
  } = (0, _use_find_maintenance_windows.useFindMaintenanceWindows)({
    enabled: hasLicense,
    page,
    perPage,
    search,
    selectedStatus
  });
  const {
    maintenanceWindows,
    total
  } = data || {
    maintenanceWindows: [],
    total: 0
  };
  (0, _use_breadcrumbs.useBreadcrumbs)(_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindows);
  const handleClickCreate = (0, _react.useCallback)(() => {
    navigateToCreateMaintenanceWindow();
  }, [navigateToCreateMaintenanceWindow]);
  const refreshData = (0, _react.useCallback)(() => refetch(), [refetch]);
  const showWindowMaintenance = (_capabilities$MAINTEN = capabilities[_common.MAINTENANCE_WINDOW_FEATURE_ID]) === null || _capabilities$MAINTEN === void 0 ? void 0 : _capabilities$MAINTEN.show;
  const writeWindowMaintenance = (_capabilities$MAINTEN2 = capabilities[_common.MAINTENANCE_WINDOW_FEATURE_ID]) === null || _capabilities$MAINTEN2 === void 0 ? void 0 : _capabilities$MAINTEN2.save;
  const isNotFiltered = search === '' && selectedStatus.length === 0;
  const showEmptyPrompt = !isLoading && maintenanceWindows.length === 0 && isNotFiltered && showWindowMaintenance && writeWindowMaintenance;
  const readOnly = showWindowMaintenance && !writeWindowMaintenance;

  // if the user is read only then display the glasses badge in the global navigation header
  const setBadge = (0, _react.useCallback)(() => {
    if (readOnly) {
      chrome.setBadge({
        text: i18n.READ_ONLY_BADGE_TEXT,
        tooltip: i18n.READ_ONLY_BADGE_TOOLTIP,
        iconType: 'glasses'
      });
    }
  }, [chrome, readOnly]);
  (0, _react.useEffect)(() => {
    setBadge();

    // remove the icon after the component unmounts
    return () => {
      chrome.setBadge();
    };
  }, [setBadge, chrome]);
  const onPageChange = (0, _react.useCallback)(({
    page: {
      index,
      size
    }
  }) => {
    setPage(index + 1);
    setPerPage(size);
  }, []);
  const onSelectedStatusChange = (0, _react.useCallback)(status => {
    setSelectedStatus(status);
  }, []);
  const onSearchChange = (0, _react.useCallback)(value => {
    setSearch(value);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    alignItems: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "m",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, i18n.MAINTENANCE_WINDOWS)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, i18n.MAINTENANCE_WINDOWS_DESCRIPTION))), !showEmptyPrompt && hasLicense && writeWindowMaintenance ? /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mw-create-button",
    onClick: handleClickCreate,
    iconType: "plusInCircle",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, i18n.CREATE_NEW_BUTTON)) : null), !hasLicense ? /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }) : showEmptyPrompt ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    onClickCreate: handleClickCreate,
    docLinks: docLinks.links,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_maintenance_windows_list.MaintenanceWindowsList, {
    readOnly: readOnly,
    refreshData: refreshData,
    isLoading: isLoading || isInitialLoading,
    items: maintenanceWindows,
    page: page,
    perPage: perPage,
    total: total,
    onPageChange: onPageChange,
    selectedStatus: selectedStatus,
    onStatusChange: onSelectedStatusChange,
    onSearchChange: onSearchChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  })));
});
MaintenanceWindowsPage.displayName = 'MaintenanceWindowsPage';
// eslint-disable-next-line import/no-default-export