"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMaintenanceWindow = updateMaintenanceWindow;
var _common = require("../../../common");
var _transform_maintenance_window_response = require("./transform_maintenance_window_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformUpdateBodySchema = updateParams => {
  return {
    title: updateParams.title,
    duration: updateParams.duration,
    r_rule: updateParams.rRule,
    ...(updateParams.categoryIds !== undefined ? {
      category_ids: updateParams.categoryIds
    } : {}),
    ...(updateParams.scopedQuery !== undefined ? {
      scoped_query: updateParams.scopedQuery
    } : {})
  };
};
async function updateMaintenanceWindow({
  http,
  maintenanceWindowId,
  updateParams
}) {
  const res = await http.post(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rules/maintenance_window/${encodeURIComponent(maintenanceWindowId)}`, {
    body: JSON.stringify(transformUpdateBodySchema(updateParams))
  });
  return (0, _transform_maintenance_window_response.transformMaintenanceWindowResponse)(res);
}