"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nanosToMicros = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nanosToMicros = nanosecondString => {
  if (!(0, _lodash.isString)(nanosecondString)) {
    return (0, _lodash.isNumber)(nanosecondString) ? nanosecondString / 1000 : 0;
  }
  try {
    const nanos = parseInt(nanosecondString, 10);
    return isNaN(nanos) ? 0 : nanos / 1000;
  } catch (err) {
    return 0;
  }
};
exports.nanosToMicros = nanosToMicros;