"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isExistingAlert = isExistingAlert;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function isExistingAlert({
  indices,
  alertId,
  ruleId,
  logger,
  esClient
}) {
  try {
    const response = await esClient.search({
      index: indices,
      allow_no_indices: true,
      size: 0,
      query: {
        bool: {
          must: [{
            term: {
              [_ruleDataUtils.ALERT_RULE_UUID]: ruleId
            }
          }],
          filter: [{
            term: {
              [_ruleDataUtils.ALERT_INSTANCE_ID]: alertId
            }
          }]
        }
      }
    });
    const total = response.hits.total == null ? 0 : typeof response.hits.total === 'number' ? response.hits.total : response.hits.total.value;
    return total > 0;
  } catch (error) {
    logger.error(`Error checking for existing alert with alertId: ${alertId} and ruleId: ${ruleId} - ${error.message}`);
    return false;
  }
}