"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformGapAutoFillSchedulerCreateParamToSavedObject = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformGapAutoFillSchedulerCreateParamToSavedObject = (params, {
  createdBy,
  createdAt,
  updatedAt,
  updatedBy
}) => {
  return {
    name: params.name,
    enabled: params.enabled,
    schedule: params.schedule,
    gapFillRange: params.gapFillRange,
    maxBackfills: params.maxBackfills,
    numRetries: params.numRetries,
    scope: params.scope,
    ruleTypes: params.ruleTypes,
    ruleTypeConsumerPairs: Array.from(new Set(params.ruleTypes.map(rt => `${rt.type}:${rt.consumer}`))),
    createdBy: createdBy !== null && createdBy !== void 0 ? createdBy : null,
    createdAt,
    updatedAt,
    updatedBy: updatedBy !== null && updatedBy !== void 0 ? updatedBy : null
  };
};
exports.transformGapAutoFillSchedulerCreateParamToSavedObject = transformGapAutoFillSchedulerCreateParamToSavedObject;