"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteGapAutoFillScheduler = deleteGapAutoFillScheduler;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _saved_objects = require("../../../../../saved_objects");
var _authorization = require("../../../../../authorization");
var _audit_events = require("../../../../../rules_client/common/audit_events");
var _schemas = require("../schemas");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteGapAutoFillScheduler(context, params) {
  try {
    _schemas.getGapAutoFillSchedulerSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating gap auto fill scheduler delete parameters "${JSON.stringify(params)}" - ${error.message}`);
  }
  const soClient = context.unsecuredSavedObjectsClient;
  const taskManager = context.taskManager;
  try {
    var _context$auditLogger;
    const schedulerSo = await (0, _utils.getGapAutoFillSchedulerSO)({
      context,
      id: params.id,
      operation: _authorization.WriteOperations.DeleteGapAutoFillScheduler,
      authAuditAction: _audit_events.GapAutoFillSchedulerAuditAction.DELETE
    });
    const schedulerName = schedulerSo.attributes.name;
    const scheduledTaskId = schedulerSo.id;
    try {
      await taskManager.removeIfExists(scheduledTaskId);
    } catch (err) {
      const errorMessage = `Unable to remove gap auto fill scheduler task for id: ${params.id}. Backfills and saved object will not be deleted.`;
      context.logger.error(`${errorMessage} - ${err}`);
      throw err;
    }
    try {
      await context.backfillClient.deleteBackfillsByInitiatorId({
        initiatorId: scheduledTaskId,
        unsecuredSavedObjectsClient: soClient,
        shouldUpdateGaps: true,
        internalSavedObjectsRepository: context.internalSavedObjectsRepository,
        eventLogClient: await context.getEventLogClient(),
        eventLogger: context.eventLogger,
        actionsClient: await context.getActionsClient()
      });
    } catch (err) {
      const errorMessage = `Unable to delete backfills for gap auto fill scheduler id: ${params.id}. Saved object will not be deleted.`;
      context.logger.error(`${errorMessage} - ${err}`);
      throw err;
    }
    try {
      await soClient.delete(_saved_objects.GAP_AUTO_FILL_SCHEDULER_SAVED_OBJECT_TYPE, params.id);
    } catch (err) {
      const errorMessage = `Unable to delete gap auto fill scheduler saved object for id: ${params.id}`;
      context.logger.error(`${errorMessage} - ${err}`);
      throw err;
    }
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.gapAutoFillSchedulerAuditEvent)({
      action: _audit_events.GapAutoFillSchedulerAuditAction.DELETE,
      savedObject: {
        type: _saved_objects.GAP_AUTO_FILL_SCHEDULER_SAVED_OBJECT_TYPE,
        id: params.id,
        name: schedulerName
      }
    }));
  } catch (err) {
    const errorMessage = `Failed to delete gap auto fill scheduler by id: ${params.id}`;
    context.logger.error(`${errorMessage} - ${err}`);
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}