"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGapAutoFillSchedulerSO = void 0;
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _saved_objects = require("../../../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches the gap auto fill scheduler saved object and performs rule type based authorization.
 */
const getGapAutoFillSchedulerSO = async ({
  context,
  id,
  operation,
  authAuditAction
}) => {
  const schedulerSO = await context.unsecuredSavedObjectsClient.get(_saved_objects.GAP_AUTO_FILL_SCHEDULER_SAVED_OBJECT_TYPE, id);

  // Check for errors in the savedObjectsClient result
  if (schedulerSO.error) {
    var _context$auditLogger;
    const err = new Error(schedulerSO.error.message);
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.gapAutoFillSchedulerAuditEvent)({
      action: _audit_events.GapAutoFillSchedulerAuditAction.GET,
      savedObject: {
        type: _saved_objects.GAP_AUTO_FILL_SCHEDULER_SAVED_OBJECT_TYPE,
        id,
        name: id
      },
      error: err
    }));
    throw err;
  }
  try {
    for (const ruleType of schedulerSO.attributes.ruleTypes) {
      await context.authorization.ensureAuthorized({
        ruleTypeId: ruleType.type,
        consumer: ruleType.consumer,
        operation,
        entity: _authorization.AlertingAuthorizationEntity.Rule
      });
    }
  } catch (error) {
    var _context$auditLogger2;
    (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.gapAutoFillSchedulerAuditEvent)({
      action: authAuditAction,
      savedObject: {
        type: _saved_objects.GAP_AUTO_FILL_SCHEDULER_SAVED_OBJECT_TYPE,
        id,
        name: schedulerSO.attributes.name
      },
      error
    }));
    throw error;
  }
  return schedulerSO;
};
exports.getGapAutoFillSchedulerSO = getGapAutoFillSchedulerSO;