"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSavedObjectToGapAutoFillSchedulerResult = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformSavedObjectToGapAutoFillSchedulerResult = ({
  savedObject
}) => {
  var _attributes$createdBy, _attributes$updatedBy;
  const {
    id,
    attributes
  } = savedObject;
  if (!id) {
    throw new Error('Malformed saved object - Missing "id".');
  }
  if (!attributes) {
    throw new Error('Malformed saved object - Missing "attributes".');
  }
  return {
    id,
    name: attributes.name,
    enabled: attributes.enabled,
    schedule: attributes.schedule,
    gapFillRange: attributes.gapFillRange,
    maxBackfills: attributes.maxBackfills,
    numRetries: attributes.numRetries,
    scope: attributes.scope,
    ruleTypes: attributes.ruleTypes,
    createdBy: (_attributes$createdBy = attributes.createdBy) !== null && _attributes$createdBy !== void 0 ? _attributes$createdBy : null,
    updatedBy: (_attributes$updatedBy = attributes.updatedBy) !== null && _attributes$updatedBy !== void 0 ? _attributes$updatedBy : null,
    createdAt: attributes.createdAt,
    updatedAt: attributes.updatedAt
  };
};
exports.transformSavedObjectToGapAutoFillSchedulerResult = transformSavedObjectToGapAutoFillSchedulerResult;