"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTypesByQuery = getRuleTypesByQuery;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _convert_rule_ids_to_kuery_node = require("../../../../lib/convert_rule_ids_to_kuery_node");
var _find_rules_so = require("../../../../data/rule/methods/find_rules_so");
var _build_kuery_node_filter = require("../../../../rules_client/common/build_kuery_node_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRuleTypesByQuery(context, params) {
  try {
    var _aggregations$ruleTyp, _aggregations$ruleTyp2;
    const {
      unsecuredSavedObjectsClient,
      ruleTypeRegistry
    } = context;
    const {
      filter,
      ids
    } = params;
    const totalRuleTypes = ruleTypeRegistry.getAllTypes().length;
    if (ids && filter) {
      throw _boom.default.badRequest("Both 'filter' and 'ids' are supplied. Define either 'ids' or 'filter' properties in method arguments");
    }
    const qNodeFilter = ids ? (0, _convert_rule_ids_to_kuery_node.convertRuleIdsToKueryNode)(ids) : (0, _build_kuery_node_filter.buildKueryNodeFilter)(filter);
    const {
      aggregations
    } = await (0, _find_rules_so.findRulesSo)({
      savedObjectsClient: unsecuredSavedObjectsClient,
      savedObjectsFindOptions: {
        filter: qNodeFilter,
        page: 1,
        perPage: 0,
        aggs: {
          ruleTypeIds: {
            terms: {
              field: 'alert.attributes.alertTypeId',
              size: totalRuleTypes
            }
          }
        }
      }
    });
    const ruleTypeIds = new Set((_aggregations$ruleTyp = aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$ruleTyp2 = aggregations.ruleTypeIds.buckets) === null || _aggregations$ruleTyp2 === void 0 ? void 0 : _aggregations$ruleTyp2.map(bucket => bucket.key)) !== null && _aggregations$ruleTyp !== void 0 ? _aggregations$ruleTyp : []);
    return {
      ruleTypes: Array.from(ruleTypeIds)
    };
  } catch (err) {
    const errorMessage = `Failed to find rule types by query`;
    context.logger.error(`${errorMessage} - ${err}`);
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}