"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRawActionsToDomainSystemActions = exports.transformRawActionsToDomainActions = void 0;
var _lodash = require("lodash");
var _common = require("../../../rules_client/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRawActionsToDomainActions = ({
  actions,
  ruleId,
  references,
  omitGeneratedValues = true,
  isSystemAction
}) => {
  const actionsWithInjectedRefs = actions ? (0, _common.injectReferencesIntoActions)(ruleId, actions, references || []) : [];
  const ruleDomainActions = actionsWithInjectedRefs.filter(action => !isSystemAction(action.id)).map(action => {
    var _action$group;
    const defaultAction = {
      group: (_action$group = action.group) !== null && _action$group !== void 0 ? _action$group : 'default',
      id: action.id,
      params: action.params,
      actionTypeId: action.actionTypeId,
      uuid: action.uuid,
      ...(action.frequency ? {
        frequency: action.frequency
      } : {}),
      ...(action.alertsFilter ? {
        alertsFilter: action.alertsFilter
      } : {}),
      ...(action.useAlertDataForTemplate ? {
        useAlertDataForTemplate: action.useAlertDataForTemplate
      } : {})
    };
    if (omitGeneratedValues) {
      return (0, _lodash.omit)(defaultAction, 'alertsFilter.query.dsl');
    }
    return defaultAction;
  });
  return ruleDomainActions;
};
exports.transformRawActionsToDomainActions = transformRawActionsToDomainActions;
const transformRawActionsToDomainSystemActions = ({
  actions,
  ruleId,
  references,
  omitGeneratedValues = true,
  isSystemAction
}) => {
  const actionsWithInjectedRefs = actions ? (0, _common.injectReferencesIntoActions)(ruleId, actions, references || []) : [];
  const ruleDomainSystemActions = actionsWithInjectedRefs.filter(action => isSystemAction(action.id)).map(action => {
    return {
      id: action.id,
      params: action.params,
      actionTypeId: action.actionTypeId,
      uuid: action.uuid,
      ...(action.useAlertDataForTemplate ? {
        useAlertDataForTemplate: action.useAlertDataForTemplate
      } : {})
    };
  });
  return ruleDomainSystemActions;
};
exports.transformRawActionsToDomainSystemActions = transformRawActionsToDomainSystemActions;