"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkUpdateRuleSo = void 0;
var _saved_objects = require("../../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkUpdateRuleSo = params => {
  const rulesToUpdate = params.rules.map(rule => ({
    type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
    id: rule.id,
    attributes: rule.attributes
  }));
  return params.savedObjectsClient.bulkUpdate(rulesToUpdate, params.options);
};
exports.bulkUpdateRuleSo = bulkUpdateRuleSo;