"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAlertFlapping = isAlertFlapping;
exports.setFlapping = setFlapping;
var _lodash = require("lodash");
var _flapping_utils = require("./flapping_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setFlapping(flappingSettings, activeAlerts = {}, recoveredAlerts = {}) {
  for (const id of (0, _lodash.keys)(activeAlerts)) {
    const alert = activeAlerts[id];
    const flapping = isAlertFlapping(flappingSettings, alert);
    alert.setFlapping(flapping);
  }
  for (const id of (0, _lodash.keys)(recoveredAlerts)) {
    const alert = recoveredAlerts[id];
    const flapping = isAlertFlapping(flappingSettings, alert);
    alert.setFlapping(flapping);
  }
}
function isAlertFlapping(flappingSettings, alert) {
  const flappingHistory = alert.getFlappingHistory() || [];
  const isCurrentlyFlapping = alert.getFlapping();
  return flappingSettings.enabled ? (0, _flapping_utils.isFlapping)(flappingSettings, flappingHistory, isCurrentlyFlapping) : false;
}