"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeRange = getTimeRange;
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWindowDurationInMs = window => {
  let durationInMs = 0;
  if (window) {
    try {
      durationInMs = (0, _common.parseDuration)(window);
    } catch (err) {
      throw new Error(_i18n.i18n.translate('xpack.alerting.invalidWindowSizeErrorMessage', {
        defaultMessage: 'Invalid format for windowSize: "{window}"',
        values: {
          window
        }
      }));
    }
  }
  return durationInMs;
};
function getTimeRange({
  forceNow,
  logger,
  queryDelay,
  window
}) {
  const queryDelayS = queryDelay !== null && queryDelay !== void 0 ? queryDelay : 0;
  const queryDelayMs = queryDelayS * 1000;
  const timeWindowMs = getWindowDurationInMs(window);
  const date = forceNow ? forceNow : new Date();
  logger.debug(`Adjusting rule query time range by ${queryDelayS} seconds`);
  const dateStart = new Date(date.valueOf() - (timeWindowMs + queryDelayMs)).toISOString();
  const dateEnd = new Date(date.valueOf() - queryDelayMs).toISOString();
  return {
    dateStart,
    dateEnd
  };
}