"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertDeleteLastRunRoute = void 0;
var _types = require("../../../../types");
var _lib = require("../../../lib");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertDeleteLastRunRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_alert_delete_last_run`,
    validate: {},
    security: {
      authz: {
        requiredPrivileges: [`${_common.API_PRIVILEGES.READ_ALERT_DELETE_SETTINGS}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const alertDeletionClient = alertingContext.getAlertDeletionClient();
    const lastRun = await alertDeletionClient.getLastRun(req);
    const response = (0, _transforms.transformAlertDeleteLastRunToResponse)({
      lastRun
    });
    return res.ok({
      body: response
    });
  })));
};
exports.alertDeleteLastRunRoute = alertDeleteLastRunRoute;