"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findAutoFillSchedulerLogsRoute = void 0;
var _gap_auto_fill_scheduler = require("../../../../../../common/routes/gaps/apis/gap_auto_fill_scheduler");
var _lib = require("../../../../lib");
var _types = require("../../../../../types");
var _transforms = require("./transforms");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findAutoFillSchedulerLogsRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_GAPS_AUTO_FILL_SCHEDULER_API_PATH}/{id}/logs`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      params: _gap_auto_fill_scheduler.findGapAutoFillSchedulerLogsParamsSchemaV1,
      body: _gap_auto_fill_scheduler.gapAutoFillSchedulerLogsRequestQuerySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForGapAutoFillScheduler();
    const {
      id
    } = req.params;
    const body = req.body;
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = (0, _transforms.transformRequestV1)(id, body);
    const result = await rulesClient.findGapAutoFillSchedulerLogs(params);
    const response = {
      body: (0, _transforms.transformResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.findAutoFillSchedulerLogsRoute = findAutoFillSchedulerLogsRoute;