"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rewriteSystemActionsReq = exports.rewriteActionsReq = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteActionsReq = actions => {
  if (!actions) return [];
  return actions.map(({
    frequency,
    alerts_filter: alertsFilter,
    use_alert_data_for_template: useAlertDataForTemplate,
    ...action
  }) => {
    var _action$group;
    return {
      group: (_action$group = action.group) !== null && _action$group !== void 0 ? _action$group : 'default',
      id: action.id,
      params: action.params,
      ...(action.uuid ? {
        uuid: action.uuid
      } : {}),
      ...(typeof useAlertDataForTemplate !== 'undefined' ? {
        useAlertDataForTemplate
      } : {}),
      ...(frequency ? {
        frequency: {
          ...(0, _lodash.omit)(frequency, 'notify_when'),
          summary: frequency.summary,
          throttle: frequency.throttle,
          notifyWhen: frequency.notify_when
        }
      } : {}),
      ...(alertsFilter ? {
        alertsFilter
      } : {})
    };
  });
};
exports.rewriteActionsReq = rewriteActionsReq;
const rewriteSystemActionsReq = actions => {
  if (!actions) return [];
  return actions.map(action => {
    return {
      id: action.id,
      params: action.params,
      ...(action.uuid ? {
        uuid: action.uuid
      } : {})
    };
  });
};
exports.rewriteSystemActionsReq = rewriteSystemActionsReq;