"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.muteAlertRoute = void 0;
var _transforms = require("./transforms");
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _types = require("../../../../types");
var _mute_alert = require("../../../../../common/routes/rule/apis/mute_alert");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const muteAlertRoute = (router, licenseState) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{rule_id}/alert/{alert_id}/_mute`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'public',
      summary: `Mute an alert`,
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {
        params: _mute_alert.muteAlertParamsSchemaV1,
        query: _mute_alert.muteAlertQuerySchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule or alert with the given ID does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = req.params;
    const query = req.query || {};
    try {
      await rulesClient.muteInstance({
        params: (0, _transforms.transformRequestParamsToApplicationV1)(params),
        query: (0, _transforms.transformRequestQueryToApplicationV1)(query)
      });
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.muteAlertRoute = muteAlertRoute;