"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findInternalRuleTemplatesRoute = void 0;
var _find = require("../../../../../common/routes/rule_template/apis/find");
var _types = require("../../../../types");
var _constants = require("../../../constants");
var _lib = require("../../../lib");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findInternalRuleTemplatesRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rule_template/_find`,
    options: {
      access: 'internal'
    },
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    validate: {
      request: {
        query: _find.findRuleTemplatesRequestQuerySchemaV1
      },
      response: {
        200: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const query = req.query;
    const result = await rulesClient.findTemplates((0, _transforms.transformFindRuleTemplatesQueryV1)(query));
    const response = {
      body: (0, _transforms.transformFindRuleTemplatesResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.findInternalRuleTemplatesRoute = findInternalRuleTemplatesRoute;