"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiKeyAsAlertAttributes = apiKeyAsAlertAttributes;
exports.apiKeyAsRuleDomainProperties = apiKeyAsRuleDomainProperties;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated TODO (http-versioning) make sure this is deprecated
 * once all of the RawRules are phased out
 */
function apiKeyAsAlertAttributes(apiKey, username, createdByUser) {
  return apiKey && apiKey.apiKeysEnabled ? {
    apiKeyOwner: username,
    apiKey: Buffer.from(`${apiKey.result.id}:${apiKey.result.api_key}`).toString('base64'),
    apiKeyCreatedByUser: createdByUser
  } : {
    apiKeyOwner: null,
    apiKey: null,
    apiKeyCreatedByUser: null
  };
}
function apiKeyAsRuleDomainProperties(apiKey, username, createdByUser) {
  return apiKey && apiKey.apiKeysEnabled ? {
    apiKeyOwner: username,
    apiKey: Buffer.from(`${apiKey.result.id}:${apiKey.result.api_key}`).toString('base64'),
    apiKeyCreatedByUser: createdByUser
  } : {
    apiKeyOwner: null,
    apiKey: null,
    apiKeyCreatedByUser: null
  };
}