"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMigrations880 = void 0;
var _uuid = require("uuid");
var _utils = require("../utils");
var _transform_to_alert_throttle = require("../../../rules_client/lib/siem_legacy_actions/transform_to_alert_throttle");
var _transform_to_notify_when = require("../../../rules_client/lib/siem_legacy_actions/transform_to_notify_when");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function addRevision(doc) {
  return {
    ...doc,
    attributes: {
      ...doc.attributes,
      revision: (0, _utils.isDetectionEngineAADRuleType)(doc) ? doc.attributes.params.version : 0
    }
  };
}
function addActionUuid(doc) {
  const {
    attributes: {
      actions
    }
  } = doc;
  return {
    ...doc,
    attributes: {
      ...doc.attributes,
      actions: actions ? actions.map(action => ({
        ...action,
        uuid: (0, _uuid.v4)()
      })) : []
    }
  };
}
function addSecuritySolutionActionsFrequency(doc) {
  if ((0, _utils.isDetectionEngineAADRuleType)(doc)) {
    const {
      attributes: {
        throttle,
        actions
      }
    } = doc;
    return {
      ...doc,
      attributes: {
        ...doc.attributes,
        actions: actions ? actions.map(action => {
          var _action$frequency, _transformToNotifyWhe;
          return {
            ...action,
            // Till now SIEM worked without action level frequencies. Instead rule level `throttle` and `notifyWhen` used
            frequency: (_action$frequency = action.frequency) !== null && _action$frequency !== void 0 ? _action$frequency : {
              summary: true,
              notifyWhen: (_transformToNotifyWhe = (0, _transform_to_notify_when.transformToNotifyWhen)(throttle)) !== null && _transformToNotifyWhe !== void 0 ? _transformToNotifyWhe : 'onActiveAlert',
              throttle: (0, _transform_to_alert_throttle.transformToAlertThrottle)(throttle)
            }
          };
        }) : []
      }
    };
  }
  return doc;
}
function unmuteSecuritySolutionCustomRules(doc) {
  if (!(0, _utils.isDetectionEngineAADRuleType)(doc)) {
    return doc;
  }
  return {
    ...doc,
    attributes: {
      ...doc.attributes,
      muteAll: false
    }
  };
}
const getMigrations880 = encryptedSavedObjects => (0, _utils.createEsoMigration)(encryptedSavedObjects, doc => true, (0, _utils.pipeMigrations)(addActionUuid, addRevision, addSecuritySolutionActionsFrequency, unmuteSecuritySolutionCustomRules));
exports.getMigrations880 = getMigrations880;