"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawRuleSchema = exports.rawRuleMonitoringSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("./v3");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const outcome = _configSchema.schema.oneOf([_configSchema.schema.literal('succeeded'), _configSchema.schema.literal('warning'), _configSchema.schema.literal('failed')]);
const rawRuleMonitoringSchema = exports.rawRuleMonitoringSchema = _configSchema.schema.object({
  run: _configSchema.schema.object({
    history: _configSchema.schema.arrayOf(_configSchema.schema.object({
      success: _configSchema.schema.boolean(),
      timestamp: _configSchema.schema.number(),
      duration: _configSchema.schema.maybe(_configSchema.schema.number()),
      outcome: _configSchema.schema.maybe(outcome)
    })),
    calculated_metrics: _configSchema.schema.object({
      p50: _configSchema.schema.maybe(_configSchema.schema.number()),
      p95: _configSchema.schema.maybe(_configSchema.schema.number()),
      p99: _configSchema.schema.maybe(_configSchema.schema.number()),
      success_ratio: _configSchema.schema.number()
    }),
    last_run: _configSchema.schema.object({
      timestamp: _configSchema.schema.string(),
      metrics: _configSchema.schema.object({
        duration: _configSchema.schema.maybe(_configSchema.schema.number()),
        total_search_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_indexing_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_detected: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_created: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        gap_duration_s: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        gap_range: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.object({
          gte: _configSchema.schema.string(),
          lte: _configSchema.schema.string()
        })))
      })
    })
  })
});
const rawRuleSchema = exports.rawRuleSchema = _v.rawRuleSchema.extends({
  monitoring: _configSchema.schema.maybe(rawRuleMonitoringSchema)
});