"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSchemaByVersion = exports.emptyState = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * WARNING: Do not modify the existing versioned schema(s) below, instead define a new version (ex: 2, 3, 4).
 * This is required to support zero-downtime upgrades and rollbacks. See https://github.com/elastic/kibana/issues/155764.
 *
 * As you add a new schema version, don't forget to change latestTaskStateSchema variable to reference the latest schema.
 * For example, changing stateSchemaByVersion[1].schema to stateSchemaByVersion[2].schema.
 */

const stateSchemaV1 = _configSchema.schema.object({
  has_errors: _configSchema.schema.boolean(),
  error_messages: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  runs: _configSchema.schema.number(),
  count_total: _configSchema.schema.number(),
  count_by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  throttle_time: _configSchema.schema.object({
    min: _configSchema.schema.string(),
    avg: _configSchema.schema.string(),
    max: _configSchema.schema.string()
  }),
  schedule_time: _configSchema.schema.object({
    min: _configSchema.schema.string(),
    avg: _configSchema.schema.string(),
    max: _configSchema.schema.string()
  }),
  throttle_time_number_s: _configSchema.schema.object({
    min: _configSchema.schema.number(),
    avg: _configSchema.schema.number(),
    max: _configSchema.schema.number()
  }),
  schedule_time_number_s: _configSchema.schema.object({
    min: _configSchema.schema.number(),
    avg: _configSchema.schema.number(),
    max: _configSchema.schema.number()
  }),
  connectors_per_alert: _configSchema.schema.object({
    min: _configSchema.schema.number(),
    avg: _configSchema.schema.number(),
    max: _configSchema.schema.number()
  }),
  count_active_by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_active_total: _configSchema.schema.number(),
  count_disabled_total: _configSchema.schema.number(),
  count_rules_by_execution_status: _configSchema.schema.object({
    success: _configSchema.schema.number(),
    error: _configSchema.schema.number(),
    warning: _configSchema.schema.number()
  }),
  count_rules_with_tags: _configSchema.schema.number(),
  count_rules_by_notify_when: _configSchema.schema.object({
    on_action_group_change: _configSchema.schema.number(),
    on_active_alert: _configSchema.schema.number(),
    on_throttle_interval: _configSchema.schema.number()
  }),
  count_rules_snoozed: _configSchema.schema.number(),
  count_rules_muted: _configSchema.schema.number(),
  count_rules_with_muted_alerts: _configSchema.schema.number(),
  count_connector_types_by_consumers: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())),
  count_rules_namespaces: _configSchema.schema.number(),
  count_rules_executions_per_day: _configSchema.schema.number(),
  count_rules_executions_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_rules_executions_failured_per_day: _configSchema.schema.number(),
  count_rules_executions_failured_by_reason_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_rules_executions_failured_by_reason_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())),
  count_rules_by_execution_status_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_rules_executions_timeouts_per_day: _configSchema.schema.number(),
  count_rules_executions_timeouts_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_failed_and_unrecognized_rule_tasks_per_day: _configSchema.schema.number(),
  count_failed_and_unrecognized_rule_tasks_by_status_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_failed_and_unrecognized_rule_tasks_by_status_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())),
  avg_execution_time_per_day: _configSchema.schema.number(),
  avg_execution_time_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  avg_es_search_duration_per_day: _configSchema.schema.number(),
  avg_es_search_duration_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  avg_total_search_duration_per_day: _configSchema.schema.number(),
  avg_total_search_duration_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  percentile_num_generated_actions_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  percentile_num_generated_actions_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())),
  percentile_num_alerts_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  percentile_num_alerts_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()))
});
const stateSchemaV2 = stateSchemaV1.extends({
  count_mw_total: _configSchema.schema.number(),
  count_mw_with_repeat_toggle_on: _configSchema.schema.number(),
  count_mw_with_filter_alert_toggle_on: _configSchema.schema.number(),
  count_alerts_total: _configSchema.schema.number(),
  count_alerts_by_rule_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())
});
const stateSchemaV3 = stateSchemaV2.extends({
  count_rules_with_linked_dashboards: _configSchema.schema.number(),
  count_rules_with_investigation_guide: _configSchema.schema.number()
});
const stateSchemaV4 = stateSchemaV3.extends({
  count_rules_snoozed_by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_rules_muted_by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())
});
const stateSchemaV5 = stateSchemaV4.extends({
  count_ignored_fields_by_rule_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())
});
const stateSchemaV6 = stateSchemaV5.extends({
  count_backfill_executions: _configSchema.schema.number(),
  count_backfills_by_execution_status_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  count_gaps: _configSchema.schema.number(),
  total_unfilled_gap_duration_ms: _configSchema.schema.number(),
  total_filled_gap_duration_ms: _configSchema.schema.number()
});
const stateSchemaByVersion = exports.stateSchemaByVersion = {
  1: {
    // A task that was created < 8.10 will go through this "up" migration
    // to ensure it matches the v1 schema.
    up: state => ({
      has_errors: state.has_errors || false,
      error_messages: state.error_messages || undefined,
      runs: state.runs || 0,
      count_total: state.count_total || 0,
      count_by_type: state.count_by_type || {},
      throttle_time: state.throttle_time || {
        min: '0s',
        avg: '0s',
        max: '0s'
      },
      schedule_time: state.schedule_time || {
        min: '0s',
        avg: '0s',
        max: '0s'
      },
      throttle_time_number_s: state.throttle_time_number_s || {
        min: 0,
        avg: 0,
        max: 0
      },
      schedule_time_number_s: state.schedule_time_number_s || {
        min: 0,
        avg: 0,
        max: 0
      },
      connectors_per_alert: state.connectors_per_alert || {
        min: 0,
        avg: 0,
        max: 0
      },
      count_active_by_type: state.count_active_by_type || {},
      count_active_total: state.count_active_total || 0,
      count_disabled_total: state.count_disabled_total || 0,
      count_rules_by_execution_status: state.count_rules_by_execution_status || {
        success: 0,
        error: 0,
        warning: 0
      },
      count_rules_with_tags: state.count_rules_with_tags || 0,
      count_rules_by_notify_when: state.count_rules_by_notify_when || {
        on_action_group_change: 0,
        on_active_alert: 0,
        on_throttle_interval: 0
      },
      count_rules_snoozed: state.count_rules_snoozed || 0,
      count_rules_muted: state.count_rules_muted || 0,
      count_rules_with_muted_alerts: state.count_rules_with_muted_alerts || 0,
      count_connector_types_by_consumers: state.count_connector_types_by_consumers || {},
      count_rules_namespaces: state.count_rules_namespaces || 0,
      count_rules_executions_per_day: state.count_rules_executions_per_day || 0,
      count_rules_executions_by_type_per_day: state.count_rules_executions_by_type_per_day || {},
      count_rules_executions_failured_per_day: state.count_rules_executions_failured_per_day || 0,
      count_rules_executions_failured_by_reason_per_day: state.count_rules_executions_failured_by_reason_per_day || {},
      count_rules_executions_failured_by_reason_by_type_per_day: state.count_rules_executions_failured_by_reason_by_type_per_day || {},
      count_rules_by_execution_status_per_day: state.count_rules_by_execution_status_per_day || {},
      count_rules_executions_timeouts_per_day: state.count_rules_executions_timeouts_per_day || 0,
      count_rules_executions_timeouts_by_type_per_day: state.count_rules_executions_timeouts_by_type_per_day || {},
      count_failed_and_unrecognized_rule_tasks_per_day: state.count_failed_and_unrecognized_rule_tasks_per_day || 0,
      count_failed_and_unrecognized_rule_tasks_by_status_per_day: state.count_failed_and_unrecognized_rule_tasks_by_status_per_day || {},
      count_failed_and_unrecognized_rule_tasks_by_status_by_type_per_day: state.count_failed_and_unrecognized_rule_tasks_by_status_by_type_per_day || {},
      avg_execution_time_per_day: state.avg_execution_time_per_day || 0,
      avg_execution_time_by_type_per_day: state.avg_execution_time_by_type_per_day || {},
      avg_es_search_duration_per_day: state.avg_es_search_duration_per_day || 0,
      avg_es_search_duration_by_type_per_day: state.avg_es_search_duration_by_type_per_day || {},
      avg_total_search_duration_per_day: state.avg_total_search_duration_per_day || 0,
      avg_total_search_duration_by_type_per_day: state.avg_total_search_duration_by_type_per_day || {},
      percentile_num_generated_actions_per_day: state.percentile_num_generated_actions_per_day || {},
      percentile_num_generated_actions_by_type_per_day: state.percentile_num_generated_actions_by_type_per_day || {},
      percentile_num_alerts_per_day: state.percentile_num_alerts_per_day || {},
      percentile_num_alerts_by_type_per_day: state.percentile_num_alerts_by_type_per_day || {}
    }),
    schema: stateSchemaV1
  },
  2: {
    up: state => ({
      ...stateSchemaByVersion[1].up(state),
      count_mw_total: state.count_mw_total || 0,
      count_mw_with_repeat_toggle_on: state.count_mw_with_repeat_toggle_on || 0,
      count_mw_with_filter_alert_toggle_on: state.count_mw_with_filter_alert_toggle_on || 0,
      count_alerts_total: state.count_alerts_total || 0,
      count_alerts_by_rule_type: state.count_alerts_by_rule_type || {}
    }),
    schema: stateSchemaV2
  },
  3: {
    up: state => ({
      ...stateSchemaByVersion[2].up(state),
      count_rules_with_linked_dashboards: state.count_rules_with_linked_dashboards || 0,
      count_rules_with_investigation_guide: state.count_rules_with_investigation_guide || 0
    }),
    schema: stateSchemaV3
  },
  4: {
    up: state => ({
      ...stateSchemaByVersion[3].up(state),
      count_rules_snoozed_by_type: state.count_rules_snoozed_by_type || {},
      count_rules_muted_by_type: state.count_rules_muted_by_type || {}
    }),
    schema: stateSchemaV4
  },
  5: {
    up: state => ({
      ...stateSchemaByVersion[4].up(state),
      count_ignored_fields_by_rule_type: state.count_ignored_fields_by_rule_type || {}
    }),
    schema: stateSchemaV5
  },
  6: {
    up: state => ({
      ...stateSchemaByVersion[5].up(state),
      count_backfill_executions: state.count_backfill_executions || 0,
      count_backfills_by_execution_status_per_day: state.count_backfills_by_execution_status_per_day || {},
      count_gaps: state.count_gaps || 0,
      total_unfilled_gap_duration_ms: state.total_unfilled_gap_duration_ms || 0,
      total_filled_gap_duration_ms: state.total_filled_gap_duration_ms || 0
    }),
    schema: stateSchemaV6
  }
};
const latestTaskStateSchema = stateSchemaByVersion[6].schema;
const emptyState = exports.emptyState = {
  has_errors: false,
  error_messages: undefined,
  runs: 0,
  count_total: 0,
  count_by_type: {},
  throttle_time: {
    min: '0s',
    avg: '0s',
    max: '0s'
  },
  schedule_time: {
    min: '0s',
    avg: '0s',
    max: '0s'
  },
  throttle_time_number_s: {
    min: 0,
    avg: 0,
    max: 0
  },
  schedule_time_number_s: {
    min: 0,
    avg: 0,
    max: 0
  },
  connectors_per_alert: {
    min: 0,
    avg: 0,
    max: 0
  },
  count_active_by_type: {},
  count_active_total: 0,
  count_disabled_total: 0,
  count_rules_by_execution_status: {
    success: 0,
    error: 0,
    warning: 0
  },
  count_rules_with_tags: 0,
  count_rules_by_notify_when: {
    on_action_group_change: 0,
    on_active_alert: 0,
    on_throttle_interval: 0
  },
  count_rules_snoozed: 0,
  count_rules_muted: 0,
  count_rules_snoozed_by_type: {},
  count_rules_muted_by_type: {},
  count_mw_total: 0,
  count_mw_with_repeat_toggle_on: 0,
  count_mw_with_filter_alert_toggle_on: 0,
  count_rules_with_muted_alerts: 0,
  count_connector_types_by_consumers: {},
  count_rules_namespaces: 0,
  count_rules_executions_per_day: 0,
  count_rules_executions_by_type_per_day: {},
  count_rules_executions_failured_per_day: 0,
  count_rules_executions_failured_by_reason_per_day: {},
  count_rules_executions_failured_by_reason_by_type_per_day: {},
  count_rules_by_execution_status_per_day: {},
  count_rules_executions_timeouts_per_day: 0,
  count_rules_executions_timeouts_by_type_per_day: {},
  count_failed_and_unrecognized_rule_tasks_per_day: 0,
  count_failed_and_unrecognized_rule_tasks_by_status_per_day: {},
  count_failed_and_unrecognized_rule_tasks_by_status_by_type_per_day: {},
  avg_execution_time_per_day: 0,
  avg_execution_time_by_type_per_day: {},
  avg_es_search_duration_per_day: 0,
  avg_es_search_duration_by_type_per_day: {},
  avg_total_search_duration_per_day: 0,
  avg_total_search_duration_by_type_per_day: {},
  percentile_num_generated_actions_per_day: {},
  percentile_num_generated_actions_by_type_per_day: {},
  percentile_num_alerts_per_day: {},
  percentile_num_alerts_by_type_per_day: {},
  count_alerts_total: 0,
  count_alerts_by_rule_type: {},
  count_backfill_executions: 0,
  count_backfills_by_execution_status_per_day: {},
  count_gaps: 0,
  total_unfilled_gap_duration_ms: 0,
  total_filled_gap_duration_ms: 0,
  count_ignored_fields_by_rule_type: {},
  count_rules_with_linked_dashboards: 0,
  count_rules_with_investigation_guide: 0
};