"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsGroupsFromFlattenGrouping = exports.getEcsGroups = void 0;
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEcsValue = (field, value) => {
  if (typeof value !== 'string') return;
  const ecsField = _alertsAsDataUtils.ecsFieldMap[field];
  if (!ecsField) return;

  // we only allow keyword group values
  if (ecsField.type !== 'keyword') return;
  if (!ecsField.array) {
    // if the ecs type is not an array, assign the value
    return value;
  } else {
    // otherwise the ecs type is an array, create a 1-element array
    return [value];
  }
};
const getEcsGroups = (groups = []) => {
  const ecsGroup = {};
  groups.forEach(group => {
    const ecsValue = getEcsValue(group.field, group.value);
    if (ecsValue) {
      ecsGroup[group.field] = ecsValue;
    }
  });
  return ecsGroup;
};
exports.getEcsGroups = getEcsGroups;
const getEcsGroupsFromFlattenGrouping = (flattenGrouping = {}) => {
  const ecsGroup = {};
  Object.keys(flattenGrouping).forEach(flattenGroup => {
    const ecsValue = getEcsValue(flattenGroup, flattenGrouping[flattenGroup]);
    if (ecsValue) {
      ecsGroup[flattenGroup] = ecsValue;
    }
  });
  return ecsGroup;
};
exports.getEcsGroupsFromFlattenGrouping = getEcsGroupsFromFlattenGrouping;