"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBoolean = isBoolean;
exports.isBooleanArray = isBooleanArray;
exports.isJSONObject = isJSONObject;
exports.isNumber = isNumber;
exports.isString = isString;
exports.isStringArray = isStringArray;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isJSONObject(obj) {
  return (0, _lodash.isPlainObject)(obj);
}
function isString(value) {
  return typeof value === 'string';
}
function isBoolean(value) {
  return typeof value === 'boolean';
}
function isNumber(value) {
  return typeof value === 'number';
}
function isStringArray(value) {
  return Array.isArray(value) && value.every(item => typeof item === 'string');
}
function isBooleanArray(value) {
  return Array.isArray(value) && value.every(item => typeof item === 'boolean');
}