"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocumentTypeFilterForServiceDestinationStatistics = getDocumentTypeFilterForServiceDestinationStatistics;
var _term_query = require("@kbn/observability-utils-common/es/queries/term_query");
var _terms_query = require("@kbn/observability-utils-common/es/queries/terms_query");
var _es_fields = require("@kbn/apm-types/es_fields");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDocumentTypeFilterForServiceDestinationStatistics(searchServiceDestinationMetrics) {
  return searchServiceDestinationMetrics ? [{
    bool: {
      filter: (0, _term_query.termQuery)(_es_fields.METRICSET_NAME, 'service_destination'),
      must_not: [...(0, _terms_query.termsQuery)(_es_fields.METRICSET_INTERVAL, _rollup.RollupInterval.TenMinutes, _rollup.RollupInterval.SixtyMinutes)]
    }
  }] : [];
}