"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KNOWN_SINGLE_VALUED_FIELDS_SET = exports.KNOWN_MULTI_VALUED_FIELDS = exports.ALL_FIELDS = void 0;
exports.ensureRequiredApmFields = ensureRequiredApmFields;
var APM_EVENT_FIELDS_MAP = _interopRequireWildcard(require("@kbn/apm-types/es_fields"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  CLOUD,
  AGENT,
  SERVICE,
  ERROR_EXCEPTION,
  SPAN_LINKS,
  HOST,
  KUBERNETES,
  CONTAINER,
  TIER,
  INDEX,
  DATA_STEAM_TYPE,
  VALUE_OTEL_JVM_PROCESS_MEMORY_HEAP,
  VALUE_OTEL_JVM_PROCESS_MEMORY_NON_HEAP,
  SPAN_STACKTRACE,
  ...CONCRETE_FIELDS
} = APM_EVENT_FIELDS_MAP;
const ALL_FIELDS = exports.ALL_FIELDS = new Set(Object.values(CONCRETE_FIELDS));
const KNOWN_MULTI_VALUED_FIELDS = exports.KNOWN_MULTI_VALUED_FIELDS = [APM_EVENT_FIELDS_MAP.CHILD_ID, APM_EVENT_FIELDS_MAP.PROCESS_ARGS, APM_EVENT_FIELDS_MAP.OTEL_SPAN_LINKS_TRACE_ID, APM_EVENT_FIELDS_MAP.OTEL_SPAN_LINKS_SPAN_ID, APM_EVENT_FIELDS_MAP.SPAN_LINKS_TRACE_ID, APM_EVENT_FIELDS_MAP.SPAN_LINKS_SPAN_ID];
const KNOWN_SINGLE_VALUED_FIELDS_SET = exports.KNOWN_SINGLE_VALUED_FIELDS_SET = new Set([...ALL_FIELDS].filter(field => !KNOWN_MULTI_VALUED_FIELDS.includes(field)));
/**
 * Validates whether the field record object contains all required fields. Throws an error
 * if it does not.
 */
function ensureRequiredApmFields(fields, required) {
  const missingRequiredFields = required.filter(key => {
    const value = fields[key];
    return value == null || Array.isArray(value) && value.length === 0;
  });
  if (missingRequiredFields.length) {
    throw new Error(`Missing required fields (${missingRequiredFields.join(', ')}) in event`);
  }
}