"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toKueryFilterFormat = exports.mergeKueries = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toKueryFilterFormat = (key, values, separator = 'OR') => values.map(value => `${key} : "${value}"`).join(` ${separator} `);
exports.toKueryFilterFormat = toKueryFilterFormat;
const mergeKueries = (filters, separator = 'AND') => filters.filter(filter => !(0, _lodash.isEmpty)(filter)).join(` ${separator} `);
exports.mergeKueries = mergeKueries;