"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmRuleUnifiedSearchBar = ApmRuleUnifiedSearchBar;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_adhoc_apm_data_view = require("../../../hooks/use_adhoc_apm_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/apm_rule_unified_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApmRuleUnifiedSearchBar({
  placeholder,
  ruleParams,
  setRuleParams
}) {
  var _ruleParams$searchCon;
  const {
    services
  } = (0, _public.useKibana)();
  const [queryError, setQueryError] = _react.default.useState();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = services;
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const searchbarPlaceholder = 'Search for APM data… (e.g. service.name: service-1)';
  const handleSubmit = payload => {
    const {
      query
    } = payload;
    try {
      setQueryError(undefined);
      (0, _esQuery.fromKueryExpression)(query === null || query === void 0 ? void 0 : query.query);
      setRuleParams('searchConfiguration', {
        query
      });
    } catch (e) {
      setQueryError(e.message);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: _i18n.i18n.translate('xpack.apm.appName', {
      defaultMessage: 'APM'
    }),
    iconType: "search",
    placeholder: placeholder || searchbarPlaceholder,
    indexPatterns: dataView ? [dataView] : undefined,
    showQueryInput: true,
    showQueryMenu: false,
    showFilterBar: false,
    showDatePicker: false,
    showSubmitButton: false,
    displayStyle: "inPage",
    onQueryChange: handleSubmit,
    onQuerySubmit: handleSubmit,
    dataTestSubj: "apmRuleUnifiedSearchBar",
    query: (_ruleParams$searchCon = ruleParams.searchConfiguration) === null || _ruleParams$searchCon === void 0 ? void 0 : _ruleParams$searchCon.query,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), queryError && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "apmSearchBarErrorCallout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, queryError));
}