"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverallHistogram = getOverallHistogram;
var _use_fetcher = require("../../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// `isRunning` refers to the search strategy as whole which might still be in the process
// of fetching more data such as correlation results. That's why we have to determine
// the `status` of the data for the latency chart separately.
function getOverallHistogram(data, isRunning) {
  const overallHistogram = data.overallHistogram === undefined && !isRunning ? [] : data.overallHistogram;
  const hasData = Array.isArray(overallHistogram) && overallHistogram.length > 0;
  const status = Array.isArray(overallHistogram) ? _use_fetcher.FETCH_STATUS.SUCCESS : _use_fetcher.FETCH_STATUS.LOADING;
  return {
    overallHistogram,
    hasData,
    status
  };
}