"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyOperationDistributionChart = DependencyOperationDistributionChart;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/correlations/constants");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_sample_chart_selection = require("../../../hooks/use_sample_chart_selection");
var _use_time_range = require("../../../hooks/use_time_range");
var _duration_distribution_chart_with_scrubber = require("../../shared/charts/duration_distribution_chart_with_scrubber");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/dependency_operation_detail_view/dependency_operation_distribution_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DependencyOperationDistributionChart() {
  var _data$allSpansDistrib, _data$allSpansDistrib2, _data$failedSpansDist, _data$failedSpansDist2, _data$allSpansDistrib3, _data$failedSpansDist3, _data$failedSpansDist4;
  const {
    clearChartSelection,
    selectSampleFromChartSelection
  } = (0, _use_sample_chart_selection.useSampleChartSelection)();

  // there is no "current" event in the dependency operation detail view
  const markerCurrentEvent = undefined;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    query: {
      dependencyName,
      spanName,
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      sampleRangeFrom = 0,
      sampleRangeTo = 0
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/operation');
  const selection = sampleRangeFrom >= 0 && sampleRangeTo > 0 ? [sampleRangeFrom, sampleRangeTo] : undefined;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    status,
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/dependencies/charts/distribution', {
      params: {
        query: {
          percentileThreshold: _constants.DEFAULT_PERCENTILE_THRESHOLD,
          dependencyName,
          spanName,
          environment,
          kuery,
          start,
          end
        }
      }
    });
  }, [dependencyName, spanName, environment, kuery, start, end]);
  const hasData = ((_data$allSpansDistrib = data === null || data === void 0 ? void 0 : (_data$allSpansDistrib2 = data.allSpansDistribution.overallHistogram) === null || _data$allSpansDistrib2 === void 0 ? void 0 : _data$allSpansDistrib2.length) !== null && _data$allSpansDistrib !== void 0 ? _data$allSpansDistrib : 0) > 0 || ((_data$failedSpansDist = data === null || data === void 0 ? void 0 : (_data$failedSpansDist2 = data.failedSpansDistribution.overallHistogram) === null || _data$failedSpansDist2 === void 0 ? void 0 : _data$failedSpansDist2.length) !== null && _data$failedSpansDist !== void 0 ? _data$failedSpansDist : 0) > 0;
  const chartData = [{
    areaSeriesColor: euiTheme.colors.vis.euiColorVis1,
    histogram: (_data$allSpansDistrib3 = data === null || data === void 0 ? void 0 : data.allSpansDistribution.overallHistogram) !== null && _data$allSpansDistrib3 !== void 0 ? _data$allSpansDistrib3 : [],
    id: _i18n.i18n.translate('xpack.apm.dependencyOperationDistributionChart.allSpansLegendLabel', {
      defaultMessage: 'All spans'
    })
  }, {
    areaSeriesColor: euiTheme.colors.vis.euiColorVis7,
    histogram: (_data$failedSpansDist3 = data === null || data === void 0 ? void 0 : (_data$failedSpansDist4 = data.failedSpansDistribution) === null || _data$failedSpansDist4 === void 0 ? void 0 : _data$failedSpansDist4.overallHistogram) !== null && _data$failedSpansDist3 !== void 0 ? _data$failedSpansDist3 : [],
    id: _i18n.i18n.translate('xpack.apm.dependencyOperationDistributionChart.failedSpansLegendLabel', {
      defaultMessage: 'Failed spans'
    })
  }];
  const percentileThresholdValue = data === null || data === void 0 ? void 0 : data.allSpansDistribution.percentileThresholdValue;
  return /*#__PURE__*/_react.default.createElement(_duration_distribution_chart_with_scrubber.DurationDistributionChartWithScrubber, {
    chartData: chartData,
    totalDocCount: data === null || data === void 0 ? void 0 : data.allSpansDistribution.totalDocCount,
    eventType: _common.ProcessorEvent.span,
    hasData: hasData,
    onChartSelection: selectSampleFromChartSelection,
    onClearSelection: clearChartSelection,
    status: status,
    markerCurrentEvent: markerCurrentEvent,
    percentileThresholdValue: percentileThresholdValue,
    selection: selection,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
}