"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsDataStreams = DiagnosticsDataStreams;
exports.getIndexTemplateState = getIndexTemplateState;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_diagnostics = require("./context/use_diagnostics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/data_stream_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DiagnosticsDataStreams() {
  const {
    diagnosticsBundle
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }, "This section shows the APM data streams and their underlying index template."), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(DataStreamsTable, {
    data: diagnosticsBundle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }));
}
function DataStreamsTable({
  data
}) {
  var _data$dataStreams;
  const columns = [{
    field: 'name',
    name: 'Data stream name'
  }, {
    field: 'template',
    name: 'Index template name',
    render: templateName => {
      const indexTemplate = data && getIndexTemplateState(data, templateName);
      return indexTemplate !== null && indexTemplate !== void 0 && indexTemplate.exists && !(indexTemplate !== null && indexTemplate !== void 0 && indexTemplate.isNonStandard) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, templateName, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "green",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 13
        }
      }, "OK")) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, templateName, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 13
        }
      }, "Non-standard"));
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: (_data$dataStreams = data === null || data === void 0 ? void 0 : data.dataStreams) !== null && _data$dataStreams !== void 0 ? _data$dataStreams : [],
    rowHeader: "firstName",
    columns: columns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 10
    }
  });
}
function getIndexTemplateState(diagnosticsBundle, templateName) {
  return diagnosticsBundle.apmIndexTemplates.find(({
    name
  }) => templateName === name);
}