"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupsCard = ServiceGroupsCard;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../shared/links/kibana");
var _service_stat = require("./service_stat");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_groups_list/service_group_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ServiceGroupsCard({
  serviceGroup,
  href,
  serviceGroupCounts,
  isLoading
}) {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const activeAlertsHref = (0, _kibana.useObservabilityActiveAlertsHref)(serviceGroup.kuery);
  const cardProps = {
    style: {
      width: isMobile ? '100%' : 286
    },
    icon: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: serviceGroup.groupName,
      color: serviceGroup.color || euiTheme.colors.backgroundFilledPrimary,
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    })),
    title: serviceGroup.groupName,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: 'column',
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, serviceGroup.description || _i18n.i18n.translate('xpack.apm.serviceGroups.cardsList.emptyDescription', {
      defaultMessage: 'No description available'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_service_stat.ServiceStat, {
      loading: isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "left",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    }, serviceGroupCounts !== undefined && _i18n.i18n.translate('xpack.apm.serviceGroups.cardsList.serviceCount', {
      defaultMessage: '{servicesCount} {servicesCount, plural, one {service} other {services}}',
      values: {
        servicesCount: serviceGroupCounts.services
      }
    })))), /*#__PURE__*/_react.default.createElement(_service_stat.ServiceStat, {
      loading: isLoading,
      grow: isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }, serviceGroupCounts && serviceGroupCounts.alerts > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: _i18n.i18n.translate('xpack.apm.home.serviceGroups.tooltip.activeAlertsExplanation', {
        defaultMessage: 'Active alerts'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: "warning",
      color: "danger",
      href: activeAlertsHref,
      onClick(e) {
        e.stopPropagation(); // prevents extra click thru to EuiCard's href destination
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.cardsList.alertCount', {
      defaultMessage: '{alertsCount} {alertsCount, plural, one {alert} other {alerts}}',
      values: {
        alertsCount: serviceGroupCounts.alerts
      }
    })))))),
    href
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: serviceGroup.groupName,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({
    layout: "vertical"
  }, cardProps, {
    "data-test-subj": "serviceGroupCard",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  })));
}