"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmIndices = ApmIndices;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/apm_indices/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const APM_INDEX_LABELS = [{
  configurationName: 'error',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.errorIndicesLabel', {
    defaultMessage: 'Error Indices'
  })
}, {
  configurationName: 'onboarding',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.onboardingIndicesLabel', {
    defaultMessage: 'Onboarding Indices'
  })
}, {
  configurationName: 'span',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.spanIndicesLabel', {
    defaultMessage: 'Span Indices'
  })
}, {
  configurationName: 'transaction',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.transactionIndicesLabel', {
    defaultMessage: 'Transaction Indices'
  })
}, {
  configurationName: 'metric',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.metricsIndicesLabel', {
    defaultMessage: 'Metrics Indices'
  })
}];

// avoid infinite loop by initializing the state outside the component
const INITIAL_STATE = {
  apmIndexSettings: []
};
function ApmIndices() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    notifications,
    application
  } = core;
  const canSave = application.capabilities.apm['settings:save'] && application.capabilities.savedObjectsManagement.edit;
  const [apmIndices, setApmIndices] = (0, _react.useState)({});
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const {
    data = INITIAL_STATE,
    refetch
  } = (0, _use_fetcher.useFetcher)((_, signal) => services.apmSourcesAccess.getApmIndexSettings({
    signal
  }), [services.apmSourcesAccess]);
  const {
    data: space
  } = (0, _use_fetcher.useFetcher)(() => {
    var _services$spaces;
    return (_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.getActiveSpace();
  }, [services.spaces]);
  (0, _react.useEffect)(() => {
    setApmIndices(data.apmIndexSettings.reduce((acc, {
      configurationName,
      savedValue
    }) => ({
      ...acc,
      [configurationName]: savedValue
    }), {}));
  }, [data]);
  const handleApplyChangesEvent = async event => {
    event.preventDefault();
    setIsSaving(true);
    try {
      await services.apmSourcesAccess.saveApmIndices({
        body: apmIndices
      });
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.succeeded.title', {
          defaultMessage: 'Indices applied'
        }),
        text: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.succeeded.text', {
          defaultMessage: 'The indices changes were successfully applied. These changes are reflected immediately in the APM UI'
        })
      });
      // Defer reload once the UI has finished rendering
      setTimeout(() => window.location.reload());
    } catch (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.failed.title', {
          defaultMessage: 'Indices could not be applied.'
        }),
        text: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.failed.text', {
          defaultMessage: 'Something went wrong when applying indices. Error: {errorMessage}',
          values: {
            errorMessage: error.message
          }
        })
      });
    } finally {
      setIsSaving(false);
    }
  };
  const handleChangeIndexConfigurationEvent = async event => {
    const {
      name,
      value
    } = event.target;
    setApmIndices({
      ...apmIndices,
      [name]: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.apmIndices.title', {
    defaultMessage: 'Indices'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.settings.apmIndices.description', {
    defaultMessage: `The APM UI uses data views to query your APM indices. If you've customized the index names that APM Server writes events to, you may need to update these patterns for the APM UI to work. Settings here take precedence over those set in kibana.yml.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }), (space === null || space === void 0 ? void 0 : space.name) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "primary",
    iconType: "spacesApp",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.settings.apmIndices.spaceDescription",
      defaultMessage: "The index settings apply to the {spaceName} space.",
      values: {
        spaceName: /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 177,
            columnNumber: 34
          }
        }, space === null || space === void 0 ? void 0 : space.name)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 19
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, APM_INDEX_LABELS.map(({
    configurationName,
    label
  }) => {
    const matchedConfiguration = data.apmIndexSettings.find(({
      configurationName: configName
    }) => configName === configurationName);
    const defaultValue = matchedConfiguration ? matchedConfiguration.defaultValue : '';
    const savedUiIndexValue = apmIndices[configurationName];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: configurationName,
      label: label,
      helpText: _i18n.i18n.translate('xpack.apm.settings.apmIndices.helpText', {
        defaultMessage: 'Overrides {configurationName}: {defaultValue}',
        values: {
          configurationName: `xpack.apm.indices.${configurationName}`,
          defaultValue
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "apmApmIndicesFieldText",
      disabled: !canSave,
      fullWidth: true,
      name: configurationName,
      placeholder: defaultValue,
      value: savedUiIndexValue,
      onChange: handleChangeIndexConfigurationEvent,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 19
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmApmIndicesCancelButton",
    onClick: refetch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.settings.apmIndices.cancelButton', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canSave && _i18n.i18n.translate('xpack.apm.settings.apmIndices.noPermissionTooltipLabel', {
      defaultMessage: "Your user role doesn't have permissions to change APM indices"
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmApmIndicesApplyChangesButton",
    fill: true,
    onClick: handleApplyChangesEvent,
    isLoading: isSaving,
    isDisabled: !canSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyButton', {
    defaultMessage: 'Apply changes'
  })))))))));
}