"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryStats = SummaryStats;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _formatters = require("../../../../common/utils/formatters");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _get_storage_explorer_links = require("./get_storage_explorer_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/summary_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SummaryStats({
  data,
  loading,
  hasData
}) {
  var _data$numberOfService;
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const serviceInventoryLink = router.link('/services', {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      comparisonEnabled,
      kuery,
      serviceGroup: ''
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "l",
    style: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(SummaryMetric, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.totalSize', {
      defaultMessage: 'Total APM size'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.totalSize.tooltip', {
      defaultMessage: 'Total storage size of all APM indices including replicas, ignoring the filter settings.'
    }),
    value: (0, _formatters.asDynamicBytes)(data === null || data === void 0 ? void 0 : data.totalSize),
    loading: loading,
    hasData: hasData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(SummaryMetric, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.diskSpaceUsedPct', {
      defaultMessage: 'Relative disk space used'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.diskSpaceUsedPct.tooltip', {
      defaultMessage: 'The percentage of the storage capacity that is currently used by all the APM indices compared to the max. storage capacity currently configured for Elasticsearch.'
    }),
    value: (0, _formatters.asPercent)(data === null || data === void 0 ? void 0 : data.diskSpaceUsedPct, 1),
    loading: loading,
    hasData: hasData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(SummaryMetric, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.deltaInSize', {
      defaultMessage: 'Delta in APM size'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.deltaInSize.tooltip', {
      defaultMessage: 'The estimated storage size used by the APM indices based on the filters selected.'
    }),
    value: (0, _formatters.asDynamicBytes)(data === null || data === void 0 ? void 0 : data.estimatedIncrementalSize),
    loading: loading,
    hasData: hasData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(SummaryMetric, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.dailyDataGeneration', {
      defaultMessage: 'Daily data generation'
    }),
    value: (0, _formatters.asDynamicBytes)(data === null || data === void 0 ? void 0 : data.dailyDataGeneration),
    loading: loading,
    hasData: hasData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(SummaryMetric, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.tracesPerMinute', {
      defaultMessage: 'Traces per minute'
    }),
    value: (0, _formatters.asTransactionRate)(data === null || data === void 0 ? void 0 : data.tracesPerMinute),
    loading: loading,
    hasData: hasData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(SummaryMetric, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.summary.numberOfServices', {
      defaultMessage: 'Number of services'
    }),
    value: ((_data$numberOfService = data === null || data === void 0 ? void 0 : data.numberOfServices) !== null && _data$numberOfService !== void 0 ? _data$numberOfService : 0).toString(),
    loading: loading,
    hasData: hasData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmSummaryStatsGoToServiceInventoryLink",
    href: serviceInventoryLink,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.summary.serviceInventoryLink', {
    defaultMessage: 'Go to Service inventory'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmSummaryStatsGoToIndexManagementLink",
    href: (0, _get_storage_explorer_links.getIndexManagementHref)(core),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.summary.indexManagementLink', {
    defaultMessage: 'Go to Index Management'
  })))))));
}
function SummaryMetric({
  label,
  value,
  tooltipContent,
  loading,
  hasData
}) {
  const xlFontSize = (0, _eui.useEuiFontSize)('xl', {
    unit: 'px'
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 5
    }
  }, tooltipContent ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 21
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, label), loading && !hasData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  })), hasData && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
            ${xlFontSize}
            font-weight: ${euiTheme.font.weight.bold};
            color: ${euiTheme.colors.textParagraph};
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, value));
}