"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceExplorerWaterfall = TraceExplorerWaterfall;
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _ebtTools = require("@kbn/ebt-tools");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_trace_explorer_samples = require("../../../hooks/use_trace_explorer_samples");
var _resetting_height_container = require("../../shared/height_retainer/resetting_height_container");
var _url_helpers = require("../../shared/links/url_helpers");
var _use_waterfall_fetcher = require("../transaction_details/use_waterfall_fetcher");
var _waterfall_with_summary = require("../transaction_details/waterfall_with_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/trace_explorer/trace_explorer_waterfall.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TraceExplorerWaterfall() {
  var _waterfallFetchResult;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const traceSamplesFetchResult = (0, _use_trace_explorer_samples.useTraceExplorerSamples)();
  const {
    query: {
      traceId,
      transactionId,
      waterfallItemId,
      rangeFrom,
      rangeTo,
      environment,
      showCriticalPath,
      detailTab
    }
  } = (0, _use_apm_params.useApmParams)('/traces/explorer/waterfall');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  (0, _react.useEffect)(() => {
    var _traceSamplesFetchRes, _nextSample$traceId, _nextSample$transacti;
    const nextSample = (_traceSamplesFetchRes = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes === void 0 ? void 0 : _traceSamplesFetchRes.traceSamples[0];
    const nextWaterfallItemId = '';
    (0, _url_helpers.replace)(history, {
      query: {
        traceId: (_nextSample$traceId = nextSample === null || nextSample === void 0 ? void 0 : nextSample.traceId) !== null && _nextSample$traceId !== void 0 ? _nextSample$traceId : '',
        transactionId: (_nextSample$transacti = nextSample === null || nextSample === void 0 ? void 0 : nextSample.transactionId) !== null && _nextSample$transacti !== void 0 ? _nextSample$transacti : '',
        waterfallItemId: nextWaterfallItemId
      }
    });
  }, [traceSamplesFetchResult.data, history]);
  const waterfallFetchResult = (0, _use_waterfall_fetcher.useWaterfallFetcher)({
    traceId,
    transactionId,
    start,
    end
  });
  (0, _react.useEffect)(() => {
    if (waterfallFetchResult.status === _public.FETCH_STATUS.SUCCESS) {
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        },
        customMetrics: {
          key1: 'traceDocsTotal',
          value1: waterfallFetchResult.waterfall.traceDocsTotal
        }
      });
    }
  }, [waterfallFetchResult, onPageReady, rangeFrom, rangeTo]);
  const onSampleClick = (0, _react.useCallback)(sample => {
    (0, _url_helpers.push)(history, {
      query: {
        traceId: sample.traceId,
        transactionId: sample.transactionId,
        waterfallItemId: ''
      }
    });
  }, [history]);
  const onTabClick = (0, _react.useCallback)(nextDetailTab => {
    (0, _url_helpers.push)(history, {
      query: {
        detailTab: nextDetailTab
      }
    });
  }, [history]);
  const onShowCriticalPathChange = (0, _react.useCallback)(nextShowCriticalPath => {
    (0, _url_helpers.push)(history, {
      query: {
        showCriticalPath: nextShowCriticalPath ? 'true' : 'false'
      }
    });
  }, [history]);
  const isWaterfallLoading = waterfallFetchResult.status === _public.FETCH_STATUS.LOADING && !waterfallFetchResult.waterfall.entryWaterfallTransaction;
  return /*#__PURE__*/_react.default.createElement(_resetting_height_container.ResettingHeightRetainer, {
    reset: !isWaterfallLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_with_summary.WaterfallWithSummary, {
    waterfallFetchResult: waterfallFetchResult.waterfall,
    waterfallFetchStatus: waterfallFetchResult.status,
    traceSamples: traceSamplesFetchResult.data.traceSamples,
    traceSamplesFetchStatus: traceSamplesFetchResult.status,
    environment: environment,
    onSampleClick: onSampleClick,
    onTabClick: onTabClick,
    detailTab: detailTab,
    waterfallItemId: waterfallItemId,
    serviceName: (_waterfallFetchResult = waterfallFetchResult.waterfall.entryWaterfallTransaction) === null || _waterfallFetchResult === void 0 ? void 0 : _waterfallFetchResult.doc.service.name,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
}