"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profilingTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_profiling_plugin = require("../../../hooks/use_profiling_plugin");
var _flamegraph = require("../../shared/profiling/flamegraph");
var _top_functions = require("../../shared/profiling/top_functions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/profiling_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ProfilingTab() {
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      transactionName,
      transactionType
    },
    path: {
      serviceName
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/transactions/view');
  const {
    isProfilingAvailable,
    isLoading
  } = (0, _use_profiling_plugin.useProfilingPlugin)();
  const tabs = (0, _react.useMemo)(() => {
    return [{
      id: 'flamegraph',
      name: _i18n.i18n.translate('xpack.apm.transactions.profiling.tabs.flamegraph', {
        defaultMessage: 'Flamegraph'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_flamegraph.ProfilingFlamegraph, {
        serviceName: serviceName,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo,
        kuery: kuery,
        transactionName: transactionName,
        transactionType: transactionType,
        environment: environment,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 13
        }
      }))
    }, {
      id: 'topNFunctions',
      name: _i18n.i18n.translate('xpack.apm.transactions.profiling.tabs.topNFunctions', {
        defaultMessage: 'Top 10 Functions'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_top_functions.ProfilingTopNFunctions, {
        serviceName: serviceName,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo,
        kuery: kuery,
        transactionName: transactionName,
        transactionType: transactionType,
        environment: environment,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 13
        }
      }))
    }];
  }, [environment, kuery, rangeFrom, rangeTo, serviceName, transactionName, transactionType]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    })));
  }
  if (isProfilingAvailable === false) {
    return /*#__PURE__*/_react.default.createElement(_public.ProfilingEmptyState, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 10
    }
  });
}
const profilingTab = exports.profilingTab = {
  dataTestSubj: 'apmProfilingTabButton',
  key: 'Profiling',
  label: _i18n.i18n.translate('xpack.apm.transactionDetails.tabs.ProfilingLabel', {
    defaultMessage: 'Universal Profiling'
  }),
  component: ProfilingTab
};