"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmAgentInstructionsMappings = void 0;
var _apm_agent_instructions = require("../../../../common/tutorial/instructions/apm_agent_instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApmAgentInstructionsMappings = exports.ApmAgentInstructionsMappings = [{
  agentName: 'java',
  title: 'Java',
  variantId: 'java',
  createAgentInstructions: _apm_agent_instructions.createJavaAgentInstructions
}, {
  agentName: 'rum-js',
  title: 'JavaScript (Real User Monitoring)',
  variantId: 'js',
  createAgentInstructions: _apm_agent_instructions.createJsAgentInstructions
}, {
  agentName: 'nodejs',
  title: 'Node.js',
  variantId: 'node',
  createAgentInstructions: _apm_agent_instructions.createNodeAgentInstructions
}, {
  agentName: 'python',
  title: 'Django',
  variantId: 'django',
  createAgentInstructions: _apm_agent_instructions.createDjangoAgentInstructions
}, {
  agentName: 'python',
  title: 'Flask',
  variantId: 'flask',
  createAgentInstructions: _apm_agent_instructions.createFlaskAgentInstructions
}, {
  agentName: 'ruby',
  title: 'Ruby on Rails',
  variantId: 'rails',
  createAgentInstructions: _apm_agent_instructions.createRailsAgentInstructions
}, {
  agentName: 'ruby',
  title: 'Rack',
  variantId: 'rack',
  createAgentInstructions: _apm_agent_instructions.createRackAgentInstructions
}, {
  agentName: 'go',
  title: 'Go',
  variantId: 'go',
  createAgentInstructions: _apm_agent_instructions.createGoAgentInstructions
}, {
  agentName: 'dotnet',
  title: '.NET',
  variantId: 'dotnet',
  createAgentInstructions: _apm_agent_instructions.createDotNetAgentInstructions
}, {
  agentName: 'php',
  title: 'PHP',
  variantId: 'php',
  createAgentInstructions: _apm_agent_instructions.createPhpAgentInstructions
}, {
  agentName: 'otlp',
  title: 'OpenTelemetry',
  variantId: 'openTelemetry',
  createAgentInstructions: _apm_agent_instructions.createOpenTelemetryAgentInstructions
}];