"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmRouter = void 0;
var _i18n = require("@kbn/i18n");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _breadcrumb = require("../app/breadcrumb");
var _trace_link = require("../app/trace_link");
var _transaction_link = require("../app/transaction_link");
var _home = require("./home");
var _service_detail = require("./service_detail");
var _mobile_service_detail = require("./mobile_service_detail");
var _settings = require("./settings");
var _onboarding = require("./onboarding");
var _redirect = require("./onboarding/redirect");
var _apm_main_template = require("./templates/apm_main_template");
var _service_groups = require("../app/service_groups");
var _comparison_rt = require("../../../common/comparison_rt");
var _diagnostics = require("../app/diagnostics");
var _transaction_details_link = require("../app/transaction_details_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/apm_route_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ServiceGroupsTitle = _i18n.i18n.translate('xpack.apm.views.serviceGroups.title', {
  defaultMessage: 'Service groups'
});
const ServiceInventoryTitle = _i18n.i18n.translate('xpack.apm.views.serviceInventory.title', {
  defaultMessage: 'Service inventory'
});

/**
 * The array of route definitions to be used when the application
 * creates the routes.
 */
const apmRoutes = {
  '/link-to/transaction': {
    element: /*#__PURE__*/_react.default.createElement(_transaction_details_link.TransactionDetailsByNameLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 14
      }
    }),
    params: t.type({
      query: t.intersection([t.type({
        transactionName: t.string,
        serviceName: t.string
      }), t.partial({
        rangeFrom: t.string,
        rangeTo: t.string
      })])
    })
  },
  '/link-to/transaction/{transactionId}': {
    element: /*#__PURE__*/_react.default.createElement(_transaction_link.TransactionLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 14
      }
    }),
    params: t.intersection([t.type({
      path: t.type({
        transactionId: t.string
      })
    }), t.partial({
      query: t.partial({
        rangeFrom: t.string,
        rangeTo: t.string,
        waterfallItemId: t.string
      })
    })])
  },
  '/link-to/trace/{traceId}': {
    element: /*#__PURE__*/_react.default.createElement(_trace_link.TraceLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 14
      }
    }),
    params: t.intersection([t.type({
      path: t.type({
        traceId: t.string
      })
    }), t.partial({
      query: t.partial({
        rangeFrom: t.string,
        rangeTo: t.string,
        waterfallItemId: t.string
      })
    })])
  },
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
      title: _i18n.i18n.translate('xpack.apm..breadcrumb.apmLabel', {
        defaultMessage: 'APM'
      }),
      href: "/",
      omitOnServerless: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    })),
    children: {
      // this route fails on navigation unless it's defined before home
      '/service-groups': {
        element: /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          title: ServiceGroupsTitle,
          href: '/service-groups',
          parentTitle: ServiceInventoryTitle,
          parentHref: '/services',
          omitOnServerless: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
          pageTitle: ServiceInventoryTitle,
          environmentFilter: false,
          showServiceGroupSaveButton: false,
          showServiceGroupsNav: true,
          selectedNavButton: "serviceGroups",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 109,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_service_groups.ServiceGroupsList, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 15
          }
        }))),
        params: t.type({
          query: t.intersection([t.type({
            rangeFrom: t.string,
            rangeTo: t.string,
            comparisonEnabled: _ioTsUtils.toBooleanRt
          }), t.partial({
            serviceGroup: t.string
          }), t.partial({
            refreshPaused: t.union([t.literal('true'), t.literal('false')]),
            refreshInterval: t.string
          }), _comparison_rt.offsetRt])
        })
      },
      ..._redirect.tutorialRedirectRoute,
      ..._onboarding.onboarding,
      ..._diagnostics.diagnosticsRoute,
      ..._settings.settingsRoute,
      ..._service_detail.serviceDetailRoute,
      ..._mobile_service_detail.mobileServiceDetailRoute,
      ..._home.homeRoute
    }
  }
};
const apmRouter = exports.apmRouter = (0, _typedReactRouterConfig.createRouter)(apmRoutes);