"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmServiceTemplate = ApmServiceTemplate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _agent_name = require("../../../../../common/agent_name");
var _apm_service_context = require("../../../../context/apm_service/apm_service_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_breadcrumb = require("../../../../context/breadcrumbs/use_breadcrumb");
var _service_anomaly_timeseries_context = require("../../../../context/service_anomaly_timeseries/service_anomaly_timeseries_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _url_helpers = require("../../../shared/links/url_helpers");
var _search_bar = require("../../../shared/search_bar/search_bar");
var _service_icons = require("../../../shared/service_icons");
var _apm_main_template = require("../apm_main_template");
var _analyze_data_button = require("./analyze_data_button");
var _use_tabs = require("./use_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/templates/apm_service_template/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApmServiceTemplate(props) {
  return /*#__PURE__*/_react.default.createElement(_apm_service_context.ApmServiceContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(TemplateWithContext, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  })));
}
function TemplateWithContext({
  title,
  children,
  selectedTab,
  searchBarOptions
}) {
  const {
    path: {
      serviceName
    },
    query,
    query: {
      rangeFrom,
      rangeTo,
      environment
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/*');
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const router = (0, _use_apm_router.useApmRouter)();
  const tabs = (0, _use_tabs.useTabs)({
    selectedTab
  });
  const {
    agentName,
    serviceAgentStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isPendingServiceAgent = !agentName && (0, _use_fetcher.isPending)(serviceAgentStatus);
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title,
    href: router.link(`/services/{serviceName}/${selectedTab}`, {
      path: {
        serviceName
      },
      query
    })
  }), [query, router, selectedTab, serviceName, title]);
  if ((0, _agent_name.isMobileAgentName)(agentName)) {
    (0, _url_helpers.replace)(history, {
      pathname: location.pathname.replace('/services/', '/mobile-services/')
    });
  }
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    pageHeader: {
      tabs,
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": "apmMainTemplateHeaderServiceName",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 21
        }
      }, serviceName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_service_icons.ServiceIcons, {
        serviceName: serviceName,
        environment: environment,
        start: start,
        end: end,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 19
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_analyze_data_button.AnalyzeDataButton, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 15
        }
      })))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, isPendingServiceAgent ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoObservability",
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, (0, _extends2.default)({}, searchBarOptions, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_service_anomaly_timeseries_context.ServiceAnomalyTimeseriesContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, children)));
}