"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMarker = ErrorMarker;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../../../../common/utils/formatters");
var _error_detail_link = require("../../../links/apm/error_detail_link");
var _legend = require("../legend");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeline/marker/error_marker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Popover = _styled.default.div`
  max-width: 280px;
`;
const ErrorLink = (0, _styled.default)(_error_detail_link.ErrorDetailLink)`
  display: block;
  overflow-wrap: break-word;
`;
const Button = (0, _styled.default)(_legend.Legend)`
  height: 20px;
  display: flex;
  align-items: flex-end;
`;

// We chose 240 characters because it fits most error messages and it's still easily readable on a screen.
function truncateMessage(errorMessage) {
  const maxLength = 240;
  if (typeof errorMessage === 'string' && errorMessage.length > maxLength) {
    return errorMessage.substring(0, maxLength) + '…';
  } else {
    return errorMessage;
  }
}
function ErrorMarker({
  mark,
  query
}) {
  var _error$error$log, _error$error$exceptio;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, showPopover] = (0, _react.useState)(false);
  const togglePopover = () => showPopover(!isPopoverOpen);
  const button = /*#__PURE__*/_react.default.createElement(Button, {
    "data-test-subj": "popover",
    clickable: true,
    color: euiTheme.colors.danger,
    shape: _legend.Shape.square,
    onClick: togglePopover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
  const {
    error
  } = mark;
  const errorMessage = ((_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.message) || ((_error$error$exceptio = error.error.exception) === null || _error$error$exceptio === void 0 ? void 0 : _error$error$exceptio.message);
  const truncatedErrorMessage = truncateMessage(errorMessage);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    anchorPosition: "upCenter",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Popover, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    text: (0, _formatters.asDuration)(mark.offset),
    indicator: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        marginRight: euiTheme.size.xs
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 26
      }
    }, "@"),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    key: mark.serviceColor,
    color: mark.serviceColor,
    text: error.service.name,
    indicator: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 26
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, mark.onClick === undefined && error.error.grouping_key && query ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(ErrorLink, {
    "data-test-subj": "errorLink",
    serviceName: error.service.name,
    errorGroupId: error.error.grouping_key,
    query: query,
    title: errorMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 17
    }
  }, truncatedErrorMessage)) : mark.onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmTimelineErrorMarkerButton",
    onClick: () => {
      var _mark$onClick;
      togglePopover();
      (_mark$onClick = mark.onClick) === null || _mark$onClick === void 0 ? void 0 : _mark$onClick.call(mark);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, truncatedErrorMessage) : truncatedErrorMessage))));
}