"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMarkerWithLink = ErrorMarkerWithLink;
var _react = _interopRequireDefault(require("react"));
var _error_marker = require("./error_marker");
var _apm = require("../../../../../../common/es_fields/apm");
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeline/marker/error_marker_with_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorMarkerWithLink({
  mark
}) {
  var _mark$error$trace, _mark$error$transacti;
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/overview', '/services/{serviceName}/errors', '/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/overview', '/mobile-services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/errors-and-crashes', '/traces/explorer/waterfall', '/dependencies/operation');
  const serviceGroup = 'serviceGroup' in query ? query.serviceGroup : '';
  const traceId = (_mark$error$trace = mark.error.trace) === null || _mark$error$trace === void 0 ? void 0 : _mark$error$trace.id;
  const transactionId = (_mark$error$transacti = mark.error.transaction) === null || _mark$error$transacti === void 0 ? void 0 : _mark$error$transacti.id;
  const kueryParts = [traceId && `${_apm.TRACE_ID} : "${traceId}"`, transactionId && `${_apm.TRANSACTION_ID} : "${transactionId}"`].filter(Boolean);
  const queryParam = {
    ...query,
    serviceGroup,
    kuery: kueryParts.join(' and ')
  };
  return /*#__PURE__*/_react.default.createElement(_error_marker.ErrorMarker, {
    mark: mark,
    query: queryParam,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 10
    }
  });
}