"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBoolFilter = getBoolFilter;
var _apm = require("../../../common/es_fields/apm");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getBoolFilter({
  groupId,
  processorEvent,
  serviceName,
  environment,
  urlParams
}) {
  const boolFilter = [];
  if (serviceName) {
    boolFilter.push({
      term: {
        [_apm.SERVICE_NAME]: serviceName
      }
    });
  }
  boolFilter.push(...(0, _environment_query.environmentQuery)(environment !== null && environment !== void 0 ? environment : _environment_filter_values.ENVIRONMENT_ALL.value));
  if (urlParams.transactionType) {
    boolFilter.push({
      term: {
        [_apm.TRANSACTION_TYPE]: urlParams.transactionType
      }
    });
  }
  switch (processorEvent) {
    case 'transaction':
      boolFilter.push({
        term: {
          [_apm.PROCESSOR_EVENT]: 'transaction'
        }
      });
      if (urlParams.transactionName) {
        boolFilter.push({
          term: {
            [_apm.TRANSACTION_NAME]: urlParams.transactionName
          }
        });
      }
      if (urlParams.transactionType) {
        boolFilter.push({
          term: {
            [_apm.TRANSACTION_TYPE]: urlParams.transactionType
          }
        });
      }
      break;
    case 'error':
      boolFilter.push({
        term: {
          [_apm.PROCESSOR_EVENT]: 'error'
        }
      });
      if (groupId) {
        boolFilter.push({
          term: {
            [_apm.ERROR_GROUP_ID]: groupId
          }
        });
      }
      break;
    case 'metric':
      boolFilter.push({
        term: {
          [_apm.PROCESSOR_EVENT]: 'metric'
        }
      });
      break;
    default:
      boolFilter.push({
        bool: {
          should: [{
            term: {
              [_apm.PROCESSOR_EVENT]: 'error'
            }
          }, {
            term: {
              [_apm.PROCESSOR_EVENT]: 'transaction'
            }
          }, {
            term: {
              [_apm.PROCESSOR_EVENT]: 'metric'
            }
          }]
        }
      });
  }
  return boolFilter;
}