"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumb = useBreadcrumb;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _react = require("react");
var _lodash = require("lodash");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _context = require("./context");
var _use_kibana_environment_context = require("../kibana_environment_context/use_kibana_environment_context");
var _use_kibana = require("../kibana_context/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBreadcrumb(callback, fnDeps, options) {
  const {
    isServerlessEnv
  } = (0, _use_kibana_environment_context.useKibanaEnvironmentContext)();
  const {
    services: {
      chrome
    }
  } = (0, _use_kibana.useKibana)();
  const {
    omitRootOnServerless = false,
    omitOnServerless = false
  } = options || {};
  const api = (0, _react.useContext)(_context.BreadcrumbsContext);
  if (!api) {
    throw new Error('Missing Breadcrumb API in context');
  }
  const {
    match
  } = (0, _typedReactRouterConfig.useCurrentRoute)();
  const matchedRoute = (0, _react.useRef)(match === null || match === void 0 ? void 0 : match.route);
  const chromeStyle = (0, _useObservable.default)(chrome.getChromeStyle$());
  (0, _react.useEffect)(() => {
    const isProjectStyle = isServerlessEnv || chromeStyle === 'project';
    if (isProjectStyle && omitOnServerless) {
      return;
    }
    if (matchedRoute.current && matchedRoute.current !== (match === null || match === void 0 ? void 0 : match.route)) {
      api.unset(matchedRoute.current);
    }
    matchedRoute.current = match === null || match === void 0 ? void 0 : match.route;
    if (matchedRoute.current) {
      const breadcrumbs = (0, _lodash.castArray)(callback());
      api.set(matchedRoute.current, isProjectStyle && omitRootOnServerless && breadcrumbs.length >= 1 ? breadcrumbs.slice(1) : breadcrumbs);
    }
    return () => {
      if (matchedRoute.current) {
        api.unset(matchedRoute.current);
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [match, chromeStyle, ...fnDeps]);
}